/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SimpleAlterSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAlterSchemaFactory<S extends AbstractSqlBuilder<?>>
extends SimpleAlterSqlFactory<Schema, S> {
    private Set<String> ALTER_COLLECTION_ORDERS = CommonUtils.linkedSet();

    public AbstractAlterSchemaFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.addCollectionOrder(SchemaObjectProperties.CONSTANTS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SEQUENCES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OPERATORS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OPERATOR_CLASSES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PACKAGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TYPES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DOMAINS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.FUNCTIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PROCEDURES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.EXTERNAL_TABLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DB_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TABLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TABLE_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.VIEWS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.MVIEW_LOGS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.MVIEWS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.RULES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TRIGGERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PACKAGE_BODIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TYPE_BODIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SYNONYMS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DIMENSIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.XML_SCHEMAS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.EVENTS.getLabel());
    }

    protected void addCollectionOrder(String name) {
        this.ALTER_COLLECTION_ORDERS.add(name);
    }

    protected Set<String> getAlterCollectionOrder() {
        return this.ALTER_COLLECTION_ORDERS;
    }

    @Override
    public List<SqlOperation> createDiffSql(DbObjectDifference difference) {
        Options operationOption;
        List<SqlOperation> sqlList = CommonUtils.list();
        Map<String, Difference<?>> allDiff = difference.toDifference().getChangedProperties(this.getDialect());
        this.addAlterSchema(difference, allDiff, sqlList);
        for (String name : this.getAlterCollectionOrder()) {
            DbObjectDifferenceCollection collectionDiff = (DbObjectDifferenceCollection)allDiff.get(name);
            if (collectionDiff == null) continue;
            this.addAlterSchemaObjects(name, collectionDiff, sqlList);
        }
        Object setPathOperationOperation = this.getSqlFactoryRegistry().getSqlFactory((Schema)difference.getTarget(), SqlType.SET_SEARCH_PATH_TO_SCHEMA);
        if (setPathOperationOperation != null && !CommonUtils.isEmpty(sqlList) && (operationOption = this.getOptions().clone()).isSetSearchPathToSchema()) {
            setPathOperationOperation.setOptions(operationOption);
            sqlList.addAll(0, setPathOperationOperation.createSql((Schema)((Schema)difference.getTarget())));
        }
        return sqlList;
    }

    protected void addAlterSchema(DbObjectDifference difference, Map<String, Difference<?>> allDiff, List<SqlOperation> sqlList) {
        DbObjectDifference characterSetDiff = (DbObjectDifference)allDiff.get(SchemaProperties.CHARACTER_SET.getLabel());
        DbObjectDifference collationDiff = (DbObjectDifference)allDiff.get(SchemaProperties.COLLATION.getLabel());
        DbObjectDifference characterSemanticsDiff = (DbObjectDifference)allDiff.get(SchemaProperties.CHARACTER_SEMANTICS.getLabel());
        this.addAlterSchema(difference, allDiff, characterSetDiff, collationDiff, characterSemanticsDiff, sqlList);
    }

    protected void addAlterSchema(DbObjectDifference difference, Map<String, Difference<?>> allDiff, DbObjectDifference characterSetDiff, DbObjectDifference collationDiff, DbObjectDifference characterSemanticsDiff, List<SqlOperation> sqlList) {
    }

    protected void addAlterSchemaObjects(String propertyName, DbObjectDifferenceCollection collectionDiff, List<SqlOperation> sqlList) {
        if (SchemaObjectProperties.TABLES.getLabel().equals(propertyName)) {
            this.addAlterTables(collectionDiff, sqlList);
        } else {
            this.addAlterSchemaObjects(collectionDiff, sqlList);
        }
    }

    protected void addAlterTables(DbObjectDifferenceCollection collectionDiff, List<SqlOperation> sqlList) {
        this.addAlterSchemaObjects(collectionDiff, sqlList);
    }

    protected void addAlterSchemaObjects(DbObjectDifferenceCollection collectionDiff, List<SqlOperation> sqlList) {
        List<SqlOperation> ret = this.createDiffSql(collectionDiff.getList());
        sqlList.addAll(ret);
    }

    @Override
    public List<SqlOperation> createSql(Schema obj) {
        return Collections.EMPTY_LIST;
    }
}

