/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractDropNamedObjectFactory;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractDropTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractDropNamedObjectFactory<Table, S> {
    @Override
    protected void addDropObject(Table obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).drop()).table();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        this.addTableComment(obj, builder);
        if (this.getDialect().supportsDropCascade()) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).cascade()).constraints();
        }
    }

    @Override
    protected List<Table> sort(List<Table> c) {
        return SchemaUtils.getNewSortedTableList(c, Table.TableOrder.DROP.getComparator());
    }

    @Override
    protected List<DbObjectDifference> sortDbObjectDifference(List<DbObjectDifference> list) {
        return this.sort(list, Table.TableOrder.DROP.getComparator());
    }

    private List<DbObjectDifference> sort(List<DbObjectDifference> list, Comparator<Table> comparator) {
        List tables = CommonUtils.list(list.size());
        for (DbObjectDifference dbObjectDifference : list) {
            if (dbObjectDifference.getOriginal() == null) continue;
            tables.add((Table)dbObjectDifference.getOriginal());
        }
        Collections.sort(tables, comparator);
        FlexList<DbObjectDifference> result = new FlexList<DbObjectDifference>();
        for (int i = 0; i < tables.size(); ++i) {
            Table table = (Table)tables.get(i);
            for (DbObjectDifference dbObjectDifference : list) {
                if (table != dbObjectDifference.getOriginal()) continue;
                result.add(dbObjectDifference);
            }
        }
        return result;
    }
}

