/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableLockMode;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractLockTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table table) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Object builder = this.createSqlBuilder();
        this.addLockTable(table, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.LOCK, table);
        return sqlList;
    }

    protected void addLockTable(Table obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lock()).table();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        this.addTableComment(obj, builder);
        TableLockMode tableLockMode = this.getLockMode(obj);
        this.addLockMode(obj, tableLockMode, builder);
    }

    protected void addLockMode(Table obj, TableLockMode tableLockMode, S builder) {
        ((AbstractSqlBuilder)builder).$if(tableLockMode != null, () -> {
            builder.in();
            ((AbstractSqlBuilder)builder.lockMode(tableLockMode)).mode();
        });
    }
}

