/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.properties.FormulaProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractSqlFactory<T extends DbCommonObject<?>, S extends AbstractSqlBuilder<?>>
implements SqlFactory<T> {
    private SqlFactoryRegistry sqlFactoryRegistry = null;
    private Dialect dialect = null;
    private Options options;

    public Dialect getDialect() {
        if (this.dialect != null) {
            return this.dialect;
        }
        if (this.getSqlFactoryRegistry() == null) {
            return this.dialect;
        }
        return this.getSqlFactoryRegistry().getDialect();
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SqlFactoryRegistry getSqlFactoryRegistry() {
        return this.sqlFactoryRegistry;
    }

    public void setSqlFactoryRegistry(SqlFactoryRegistry sqlFactoryRegistry) {
        this.sqlFactoryRegistry = sqlFactoryRegistry;
    }

    protected String toString(Collection<String> args) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                builder.append("\n");
            } else {
                first = false;
            }
            builder.append(arg);
        }
        return builder.toString();
    }

    protected void initialize(AbstractSqlBuilder<?> builder) {
    }

    @Override
    public List<SqlOperation> createSql(Collection<T> c) {
        List<SqlOperation> list = CommonUtils.list();
        List<Collection<T>> sorted = this.sort(CommonUtils.list(c));
        for (DbCommonObject dbCommonObject : sorted) {
            List<SqlOperation> ret = this.createSql(dbCommonObject);
            List<SqlOperation> startList = this.getStartSqlOperations(dbCommonObject);
            list.addAll(startList);
            list.addAll(ret);
            List<SqlOperation> endList = this.getEndSqlOperations(dbCommonObject);
            list.addAll(endList);
        }
        return list;
    }

    protected List<T> sort(List<T> c) {
        return c;
    }

    protected void add(List<SqlOperation> list, SqlOperation ... operations) {
        if (CommonUtils.isEmpty(operations)) {
            return;
        }
        for (SqlOperation operation : operations) {
            if (operation == null || CommonUtils.isEmpty(operation.getSqlText())) continue;
            list.add(operation);
        }
    }

    @Override
    public List<SqlOperation> createDiffSql(Collection<DbObjectDifference> differenceCollection) {
        List<SqlOperation> operations;
        Object sqlFactory;
        List<SqlOperation> result = CommonUtils.list();
        List<DbObjectDifference> diffrences = DbObjectDifferenceCollection.getByStates(differenceCollection, State.Deleted);
        if (!CommonUtils.isEmpty(diffrences)) {
            sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(CommonUtils.first(diffrences));
            diffrences = this.sort((SqlFactory<?>)sqlFactory, diffrences);
            for (DbObjectDifference dbObjectDifference : diffrences) {
                operations = sqlFactory.createDiffSql(dbObjectDifference);
                result.addAll(operations);
            }
        }
        if (!CommonUtils.isEmpty(diffrences = DbObjectDifferenceCollection.getByStates(differenceCollection, State.Added))) {
            sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(CommonUtils.first(diffrences));
            diffrences = this.sort((SqlFactory<?>)sqlFactory, diffrences);
            for (DbObjectDifference dbObjectDifference : diffrences) {
                operations = sqlFactory.createDiffSql(dbObjectDifference);
                result.addAll(operations);
            }
        }
        if (!CommonUtils.isEmpty(diffrences = DbObjectDifferenceCollection.getByStates(differenceCollection, State.Modified))) {
            sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(CommonUtils.first(diffrences));
            diffrences = this.sort((SqlFactory<?>)sqlFactory, diffrences);
            for (DbObjectDifference dbObjectDifference : diffrences) {
                List<SqlOperation> dbOperations = sqlFactory.createDiffSql(dbObjectDifference);
                result.addAll(dbOperations);
            }
        }
        return result;
    }

    protected List<DbObjectDifference> sort(SqlFactory<?> sqlFactory, List<DbObjectDifference> list) {
        if (sqlFactory instanceof AbstractSqlFactory) {
            return ((AbstractSqlFactory)sqlFactory).sortDbObjectDifference(list);
        }
        return list;
    }

    protected List<DbObjectDifference> sortDbObjectDifference(List<DbObjectDifference> list) {
        return list;
    }

    @Override
    public List<SqlOperation> createDiffSql(DbObjectDifference obj) {
        return this.createSql(this.getObject(obj));
    }

    private T getObject(DbObjectDifference obj) {
        if (obj.getState() == State.Deleted) {
            return (T)((DbCommonObject)obj.getOriginal());
        }
        return (T)((DbCommonObject)obj.getTarget());
    }

    protected List<SqlOperation> getStartSqlOperations(T obj) {
        return Collections.EMPTY_LIST;
    }

    protected List<SqlOperation> getEndSqlOperations(T obj) {
        return Collections.EMPTY_LIST;
    }

    protected boolean addSchemaName(DbObject<?> object, AbstractSqlBuilder<?> builder) {
        SchemaNameProperty schemaName;
        if (object instanceof SchemaNameProperty && !CommonUtils.isEmpty((schemaName = (SchemaNameProperty)((Object)object)).getSchemaName())) {
            builder.name(schemaName.getSchemaName());
            return true;
        }
        return false;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            return this.getSqlFactoryRegistry().getOption();
        }
        return this.options;
    }

    @Override
    public void setOptions(Options option) {
        this.options = option;
    }

    protected void addSql(List<SqlOperation> sqlList, SqlOperation sqlOperation) {
        sqlList.add(sqlOperation);
    }

    protected void addSql(List<SqlOperation> sqlList, AbstractSqlBuilder<?> builder, SqlType sqlType, DbCommonObject<?> original) {
        if (builder == null) {
            return;
        }
        boolean bool = this.isTargetSql(sqlType, original);
        if (!bool) {
            return;
        }
        String sql = builder.toString();
        if (CommonUtils.isEmpty(sql)) {
            return;
        }
        sqlList.add(this.createOperation(sql, sqlType, original));
    }

    private boolean isTargetSql(SqlType sqlType, DbCommonObject<?> original) {
        if (sqlType.isComment()) {
            boolean bool = this.getOptions().getOutputCommit().test(original);
            return bool;
        }
        return true;
    }

    protected void addSql(List<SqlOperation> sqlList, AbstractSqlBuilder<?> builder, SqlType sqlType, List<? extends DbCommonObject<?>> originals) {
        if (builder == null) {
            return;
        }
        String sql = builder.toString();
        if (CommonUtils.isEmpty(sql)) {
            return;
        }
        if (originals.size() == 1) {
            boolean bool = this.isTargetSql(sqlType, originals.get(0));
            if (!bool) {
                return;
            }
            sqlList.add(this.createOperation(sql, sqlType, originals.get(0)));
        } else {
            sqlList.add(this.createOperation(sql, sqlType, originals));
        }
    }

    protected SqlOperation createOperation(String text, SqlType sqlType, DbCommonObject<?> original, DbCommonObject<?> target) {
        SqlOperation operation = new SqlOperation(text, sqlType, original, target);
        this.initialize(operation);
        return operation;
    }

    protected SqlOperation createOperation(String text, SqlType sqlType, DbCommonObject<?> original) {
        SqlOperation operation = new SqlOperation(text, sqlType, original);
        this.initialize(operation);
        return operation;
    }

    protected SqlOperation createOperation(String text, SqlType sqlType, List<? extends DbCommonObject<?>> originals) {
        SqlOperation operation = new SqlOperation(text, sqlType, originals);
        this.initialize(operation);
        return operation;
    }

    protected SqlOperation createOperation(String text, SqlType sqlType, List<? extends DbCommonObject<?>> originals, List<? extends DbCommonObject<?>> targets) {
        SqlOperation operation = new SqlOperation(text, sqlType, originals, targets);
        this.initialize(operation);
        return operation;
    }

    protected void initialize(SqlOperation operation) {
        this.getDialect().setChangeAndResetSqlDelimiter(operation);
    }

    protected boolean isOptimisticLockColumn(Column column) {
        TableOptions option = this.getOptions().getTableOptions();
        if (CommonUtils.isEmpty(option.getOptimisticLockColumn())) {
            return this.getDialect().isOptimisticLockColumn(column);
        }
        return option.getOptimisticLockColumn().test(column);
    }

    protected String getOptimisticLockColumnUpdateDefinition(String prefix, Column column) {
        return this.getOptimisticLockColumnUpdateDefinition(prefix, column, 1);
    }

    protected String getOptimisticLockColumnUpdateDefinition(String prefix, Column column, Integer increment) {
        if (column.getDataType().isNumeric()) {
            if (column.isNotNull()) {
                if (increment != null) {
                    return this.combine(prefix, this.getQuoteName(column)) + " + " + increment;
                }
                return this.combine(prefix, this.getQuoteName(column));
            }
            if (!this.withCoalesceAtUpdate(column)) {
                if (increment != null) {
                    return this.combine(prefix, this.getQuoteName(column)) + " + " + increment;
                }
                return this.combine(prefix, this.getQuoteName(column));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("COALESCE( ");
            builder.append(this.combine(prefix, this.getQuoteName(column)));
            builder.append(", ");
            if (CommonUtils.isEmpty(column.getDefaultValue())) {
                builder.append("0");
            } else {
                builder.append(column.getDefaultValue());
            }
            builder.append(" )");
            if (increment != null) {
                builder.append(" + ");
                builder.append(increment);
            }
            return builder.toString();
        }
        return null;
    }

    protected String getOptimisticLockColumnCondition(Column column) {
        if (column.getDataType().isNumeric()) {
            StringBuilder builder = new StringBuilder();
            String value = this.getValueDefinitionSimple(column);
            builder.append("COALESCE( ");
            builder.append(value);
            builder.append(", ");
            builder.append(this.getQuoteName(column));
            builder.append(", ");
            if (CommonUtils.isEmpty(column.getDefaultValue())) {
                builder.append("0");
            } else {
                builder.append(column.getDefaultValue());
            }
            builder.append(" )");
            return builder.toString();
        }
        if (column.getDataType().isBinary()) {
            return this.getQuoteName(column);
        }
        return null;
    }

    protected String getQuoteName(Column column) {
        if (this.getDialect() != null && this.getDialect().needQuote(column.getName())) {
            if (this.getOptions().isQuateColumnName()) {
                return this.getDialect().quote(column.getName());
            }
            return column.getName();
        }
        return column.getName();
    }

    protected String getQuoteName(String prefix, Column column) {
        if (this.getDialect() != null && this.getDialect().needQuote(column.getName())) {
            if (this.getOptions().isQuateColumnName()) {
                return this.combine(prefix, this.getDialect().quote(column.getName()));
            }
            return this.combine(prefix, column.getName());
        }
        return this.combine(prefix, column.getName());
    }

    private String combine(String text1, String text2) {
        if (text1 == null) {
            return text2;
        }
        if (text2 == null) {
            return text1;
        }
        return text1 + text2;
    }

    protected boolean isCreatedAtColumn(Column column) {
        TableOptions option = this.getOptions().getTableOptions();
        return option.getCreatedAtColumn().test(column);
    }

    protected boolean isUpdatedAtColumn(Column column) {
        TableOptions option = this.getOptions().getTableOptions();
        return option.getUpdatedAtColumn().test(column);
    }

    protected boolean isAutoIncrementColumn(Column column) {
        TableOptions option = this.getOptions().getTableOptions();
        return option.getAutoIncrementColumn().test(column);
    }

    protected String getCurrentDateDefinition(Column column) {
        if (!column.getDataType().isDateTime()) {
            return null;
        }
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        return dbDataType.getDefaultValueLiteral();
    }

    protected boolean withCoalesceAtInsert(Column column) {
        return this.getOptions().getTableOptions().getWithCoalesceAtInsert().test(column);
    }

    protected boolean withCoalesceAtUpdate(Column column) {
        return this.getOptions().getTableOptions().getWithCoalesceAtUpdate().test(column);
    }

    protected String getValueDefinitionForInsert(Column column) {
        if (this.isFormulaColumn(column)) {
            return null;
        }
        if (!this.getDialect().supportsColumnFormula() && !CommonUtils.isEmpty(column.getFormula())) {
            return column.getFormula();
        }
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        String dbTypeDefault = dbDataType.getDefaultValueLiteral();
        String columnDefault = column.getDefaultValue();
        String _default = CommonUtils.coalesce(columnDefault, dbTypeDefault);
        if (this.isAutoIncrementColumn(column)) {
            return this.getDialect().getIdentityInsertString();
        }
        if (this.isOptimisticLockColumn(column)) {
            return _default;
        }
        if (this.isCreatedAtColumn(column)) {
            if (!this.withCoalesceAtInsert(column) && !CommonUtils.isEmpty(dbTypeDefault)) {
                return dbTypeDefault;
            }
            return this.getCoalesceValueDefinition(column, _default, dbTypeDefault);
        }
        if (this.isUpdatedAtColumn(column)) {
            if (!this.withCoalesceAtUpdate(column) && !CommonUtils.isEmpty(dbTypeDefault)) {
                return dbTypeDefault;
            }
            return this.getCoalesceValueDefinition(column, _default, dbTypeDefault);
        }
        return this.getColumnParameterExpression(column, _default);
    }

    protected String getValueDefinitionSimple(Column column) {
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        String dbTypeDefault = dbDataType.getDefaultValueLiteral();
        String columnDefault = column.getDefaultValue();
        String _default = CommonUtils.coalesce(columnDefault, dbTypeDefault);
        return this.getColumnParameterExpression(column, _default);
    }

    private String getColumnParameterExpression(Column column, String _default) {
        if (this.getOptions() != null && this.getOptions().getTableOptions() != null && this.getOptions().getTableOptions().getParameterExpression() != null) {
            return (String)this.getOptions().getTableOptions().getParameterExpression().apply(column, _default);
        }
        if (_default == null) {
            return "/*" + column.getName() + "*/1";
        }
        if (_default.contains("(")) {
            return "/*" + column.getName() + "*/''";
        }
        return "/*" + column.getName() + "*/" + _default;
    }

    private String getCoalesceValueDefinition(Column column, String columnDefault, String typeDefault) {
        if (CommonUtils.isEmpty(typeDefault)) {
            return this.getColumnParameterExpression(column, columnDefault);
        }
        return "COALESCE(" + this.getColumnParameterExpression(column, columnDefault) + ", " + typeDefault + ")";
    }

    protected String getValueDefinitionForUpdate(Column column) {
        return this.getValueDefinitionForUpdate((String)null, column);
    }

    protected String getValueDefinitionForUpdate(String prefix, Column column) {
        if (this.isFormulaColumn(column)) {
            return null;
        }
        if (!this.getDialect().supportsColumnFormula() && !CommonUtils.isEmpty(column.getFormula())) {
            return column.getFormula();
        }
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        String dbTypeDefault = dbDataType.getDefaultValueLiteral();
        String columnDefault = column.getDefaultValue();
        String _default = CommonUtils.coalesce(columnDefault, dbTypeDefault);
        if (this.isAutoIncrementColumn(column)) {
            return null;
        }
        if (this.isCreatedAtColumn(column)) {
            return null;
        }
        if (this.isUpdatedAtColumn(column)) {
            if (!this.withCoalesceAtUpdate(column) && !CommonUtils.isEmpty(dbTypeDefault)) {
                return dbTypeDefault;
            }
            return this.getCoalesceValueDefinition(column, _default, dbTypeDefault);
        }
        if (this.isOptimisticLockColumn(column)) {
            return this.getOptimisticLockColumnUpdateDefinition(prefix, column);
        }
        return this.getColumnParameterExpression(column, _default);
    }

    protected String getDefaultValueDefinition(Column column) {
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        String dbTypeDefault = dbDataType.getDefaultValueLiteral();
        String columnDefault = column.getDefaultValue();
        return columnDefault != null ? columnDefault : dbTypeDefault;
    }

    protected String getValueDefinitionForInsert(Row row, Column column) {
        if (this.isFormulaColumn(column)) {
            return null;
        }
        if (!this.getDialect().supportsColumnFormula() && !CommonUtils.isEmpty(column.getFormula())) {
            return column.getFormula();
        }
        String columnDefault = column.getDefaultValue();
        Object value = row.get(column);
        TableOptions tableOption = this.getOptions().getTableOptions();
        if (this.isAutoIncrementColumn(column)) {
            if (value == null) {
                return (String)tableOption.getInsertRowSqlValue().apply(row, column, this.getDialect().getIdentityInsertString());
            }
        } else if (this.isUpdatedAtColumn(column)) {
            if (value == null) {
                return (String)tableOption.getInsertRowSqlValue().apply(row, column, this.getCurrentDateDefinition(column));
            }
        } else if (this.isCreatedAtColumn(column)) {
            if (value == null) {
                return (String)tableOption.getInsertRowSqlValue().apply(row, column, this.getCurrentDateDefinition(column));
            }
        } else if (this.isOptimisticLockColumn(column) && value == null) {
            return (String)tableOption.getInsertRowSqlValue().apply(row, column, columnDefault);
        }
        if (value instanceof String && tableOption.getDynamicValue().test((String)value)) {
            return (String)value;
        }
        return (String)tableOption.getInsertRowSqlValue().apply(row, column, this.getDialect().getSqlValueDefinition(column, value));
    }

    protected String getValueDefinitionForUpdate(Row row, Column column) {
        if (this.isFormulaColumn(column)) {
            return null;
        }
        if (!this.getDialect().supportsColumnFormula() && !CommonUtils.isEmpty(column.getFormula())) {
            return column.getFormula();
        }
        Object value = row.get(column);
        TableOptions tableOption = this.getOptions().getTableOptions();
        if (this.isAutoIncrementColumn(column)) {
            if (value == null) {
                return (String)tableOption.getUpdateRowSqlValue().apply(row, column, null);
            }
        } else {
            if (this.isOptimisticLockColumn(column)) {
                return (String)tableOption.getUpdateRowSqlValue().apply(row, column, this.getOptimisticLockColumnUpdateDefinition(null, column));
            }
            if (this.isUpdatedAtColumn(column)) {
                return (String)tableOption.getUpdateRowSqlValue().apply(row, column, this.getCurrentDateDefinition(column));
            }
            if (this.isCreatedAtColumn(column)) {
                // empty if block
            }
        }
        if (value instanceof String && tableOption.getDynamicValue().test((String)value)) {
            return (String)value;
        }
        return (String)tableOption.getUpdateRowSqlValue().apply(row, column, this.getDialect().getSqlValueDefinition(column, value));
    }

    protected String getValueDefinitionForCondition(Row row, Column column) {
        Object value = row.get(column);
        if (value == null) {
            return "IS NULL";
        }
        return this.getDialect().getSqlValueDefinition(column, value);
    }

    protected S createSqlBuilder(Dialect dialect) {
        S builder = this.newSqlBuilder(dialect);
        ((AbstractSqlBuilder)builder).setQuateObjectName(this.getOptions().isQuateObjectName());
        ((AbstractSqlBuilder)builder).setQuateColumnName(this.getOptions().isQuateColumnName());
        this.initialize((AbstractSqlBuilder<?>)builder);
        return builder;
    }

    protected S newSqlBuilder(Dialect dialect) {
        return (S)dialect.createSqlBuilder();
    }

    protected Map<String, Difference<?>> getAll(Map<String, Difference<?>> allDiff, String ... args) {
        Map<String, Difference<?>> result = CommonUtils.map();
        for (String arg : args) {
            Difference<?> diff = allDiff.get(arg);
            if (diff == null) continue;
            result.put(arg, diff);
        }
        return result;
    }

    protected boolean isFormulaColumn(FormulaProperty<?> p) {
        return this.getDialect().supportsColumnFormula() && !CommonUtils.isEmpty(p.getFormula());
    }
}

