/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractSqlFactory;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.SimpleBeanWrapper;
import java.util.List;

public class CompositeSqlFactory
extends AbstractSqlFactory<DbObject<?>, AbstractSqlBuilder<?>> {
    private List<SqlFactory<?>> commands;

    public CompositeSqlFactory(SqlFactory<?> ... commands) {
        this.commands = CommonUtils.list(commands);
    }

    public CompositeSqlFactory(List<SqlFactory<?>> commands) {
        this.commands = commands;
    }

    @Override
    public List<SqlOperation> createSql(DbObject<?> obj) {
        return this.getSqlFromObject(obj);
    }

    protected List<SqlOperation> getSqlFromObject(Object obj) {
        List<SqlOperation> result = CommonUtils.list();
        for (SqlFactory<?> command : this.commands) {
            List value = (List)SimpleBeanUtils.getInstance(command.getClass()).invoke(command, "createSql", obj);
            result.addAll(value);
        }
        return result;
    }

    protected List<SqlOperation> getSqlFromObject(Difference<?> obj) {
        List<SqlOperation> result = CommonUtils.list();
        for (SqlFactory<?> command : this.commands) {
            SimpleBeanWrapper beanWrapper = SimpleBeanUtils.getInstance(command.getClass());
            List value = null;
            if (beanWrapper.hasMethod("createSql", obj)) {
                value = (List)beanWrapper.invoke(command, "createSql", obj);
                result.addAll(value);
                continue;
            }
            value = obj.getState() == State.Added ? (List)beanWrapper.invoke(command, "createSql", obj.getTarget()) : (obj.getState() == State.Deleted ? (List)beanWrapper.invoke(command, "createSql", obj.getOriginal()) : (List)beanWrapper.invoke(command, "createSql", obj.getTarget() != null ? obj.getTarget() : obj.getOriginal()));
            result.addAll(value);
        }
        return result;
    }
}

