/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.AbstractSqlFactory;
import com.sqlapp.data.db.sql.AddObjectDetail;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;

public abstract class SimpleSqlFactory<T extends DbCommonObject<?>, S extends AbstractSqlBuilder<?>>
extends AbstractSqlFactory<T, S> {
    protected S createSqlBuilder() {
        return this.newSqlBuilder(this.getDialect());
    }

    @Override
    protected S newSqlBuilder(Dialect dialect) {
        return (S)dialect.createSqlBuilder();
    }

    protected <X extends AbstractDbObject<?>, Y extends AbstractSqlBuilder<?>> AddObjectDetail<X, Y> getAddObjectDetail(X obj, SqlType sqlType) {
        Object factory = this.getSqlFactoryRegistry().getSqlFactory(obj, sqlType);
        if (factory instanceof AddObjectDetail) {
            return (AddObjectDetail)factory;
        }
        return null;
    }

    protected boolean isInsertable(Column column) {
        return this.getOptions().getTableOptions().getInsertableColumn().test(column);
    }

    protected boolean isUpdateable(Column column) {
        if (!this.getOptions().getTableOptions().getUpdateableColumn().test(column)) {
            return false;
        }
        return !this.getOptions().getTableOptions().getCreatedAtColumn().test(column);
    }

    protected void addSelectColumnComment(Column column, S builder) {
        String comment = (String)this.getOptions().getTableOptions().getSelectColumnComment().apply((String)((Object)column));
        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
        }
    }

    protected void addInsertColumnComment(Column column, S builder) {
        String comment = (String)this.getOptions().getTableOptions().getUpdateColumnComment().apply((String)((Object)column));
        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
        }
    }

    protected void addUpdateColumnComment(Column column, S builder) {
        String comment = (String)this.getOptions().getTableOptions().getUpdateColumnComment().apply((String)((Object)column));
        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
        }
    }

    protected void addWhereColumnComment(Column column, S builder) {
        String comment = (String)this.getOptions().getTableOptions().getWhereColumnComment().apply((String)((Object)column));
        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
        }
    }

    protected void addTableComment(Table table, S builder) {
        String comment = (String)this.getOptions().getTableOptions().getTableComment().apply((String)((Object)table));
        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, table.getName())) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
        }
    }
}

