/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.geometry.AbstractGeometry;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;

public abstract class AbstractMultiPoint<T extends AbstractPoint2D>
extends AbstractGeometry {
    private static final long serialVersionUID = 3280634501061893212L;
    protected T[] points;

    protected abstract T[] newArray(int var1);

    protected abstract T newPoint(double ... var1);

    @SafeVarargs
    protected AbstractMultiPoint(T ... points) {
        this.points = this.newArray(points.length);
        for (int i = 0; i < points.length; ++i) {
            this.points[i] = points[i];
        }
    }

    protected AbstractMultiPoint(double ... args) {
        this.setPoint(args);
    }

    protected void setPoint(double ... args) {
        int size = args.length / this.getDimension();
        this.points = this.newArray(size);
        double[] values = new double[this.getDimension()];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < this.getDimension(); ++j) {
                values[j] = args[this.getDimension() * i + j];
            }
            this.points[i] = this.newPoint(values);
        }
    }

    protected AbstractMultiPoint() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getOpen());
        for (int i = 0; i < this.points.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(this.points[i]);
        }
        builder.append(this.getClose());
        return builder.toString();
    }

    @Override
    protected void hashCode(HashCodeBuilder builder) {
        for (int i = 0; i < this.points.length; ++i) {
            builder.append(i);
            if (this.points[i] == null) continue;
            builder.append(((AbstractGeometry)this.points[i]).hashCode());
        }
    }

    protected char getOpen() {
        return '(';
    }

    protected char getClose() {
        return ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractMultiPoint)) {
            return false;
        }
        AbstractMultiPoint cst = (AbstractMultiPoint)obj;
        for (int i = 0; i < this.points.length; ++i) {
            if (CommonUtils.eq(this.points[i], cst.points[i])) continue;
            return false;
        }
        return true;
    }

    public T[] getPoints() {
        return this.points;
    }

    public void setPoints(T ... points) {
        AbstractPoint2D[] newPoints = this.newArray(points.length);
        for (int i = 0; i < points.length; ++i) {
            newPoints[i] = ((AbstractPoint2D)points[i]).clone();
        }
        this.points = newPoints;
    }

    public AbstractMultiPoint<?> clone() {
        try {
            return (AbstractMultiPoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

