/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Circle3D;
import com.sqlapp.data.geometry.ToUpperDimensionType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;

public class Circle
extends AbstractPoint2D
implements ToUpperDimensionType<Circle3D> {
    private static final long serialVersionUID = 3280634501061893212L;
    private double r = 0.0;

    public Circle() {
    }

    public Circle(double x, double y, double r) {
        super(x, y);
        this.r = r;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<(").append(this.getX()).append(",").append(this.getY()).append("),").append(this.getR()).append(">");
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Circle)) {
            return false;
        }
        Circle cst = (Circle)obj;
        return CommonUtils.eq(this.getR(), cst.getR());
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    @Override
    public Circle clone() {
        return new Circle(this.getX(), this.getY(), this.r);
    }

    @Override
    public Circle3D toUpperDimension() {
        return new Circle3D(this.getX(), this.getY(), 0.0, this.getR());
    }

    @Override
    protected void hashCode(HashCodeBuilder builder) {
        builder.append(this.r);
    }

    @Override
    public Circle setValue(String text) {
        text = CommonUtils.unwrap(text, "<", ">");
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setX(vals[0]);
        this.setY(vals[1]);
        this.setR(vals[2]);
        return this;
    }
}

