/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Box;
import com.sqlapp.data.geometry.Line;
import com.sqlapp.data.geometry.Lseg3D;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.ToUpperDimensionType;
import com.sqlapp.util.CommonUtils;

public final class Lseg
extends AbstractMultiPoint<Point>
implements ToUpperDimensionType<Lseg3D> {
    private static final long serialVersionUID = 7043949685038533776L;

    public Lseg(Point point1, Point point2) {
        super((AbstractPoint2D[])new Point[]{point1, point2});
    }

    public Lseg(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public Lseg() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof Lseg;
    }

    @Override
    public Lseg clone() {
        return (Lseg)super.clone();
    }

    protected Point[] newArray(int size) {
        return new Point[size];
    }

    @Override
    protected Point newPoint(double ... a) {
        return new Point(a[0], a[1]);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Lseg3D toUpperDimension() {
        Point3D[] points = new Point3D[((Point[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point[])this.points)[i].toUpperDimension();
        }
        return new Lseg3D(points[0], points[1]);
    }

    @Override
    public Lseg setValue(String text) {
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setPoint(vals);
        return this;
    }

    public Line toLine() {
        Line line = new Line(((Point[])this.getPoints())[0].clone(), ((Point[])this.getPoints())[1].clone());
        return line;
    }

    public Box toBox() {
        Box box = new Box(((Point[])this.getPoints())[0].clone(), ((Point[])this.getPoints())[1].clone());
        return box;
    }
}

