/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.AbstractBaseDbObjectCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DimensionLevelColumnCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.GetAllDbObjectEqualsHandler;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.UnOrdered;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.StringUtils;
import com.sqlapp.util.xml.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

abstract class AbstractBaseDbObjectCollection<T extends AbstractBaseDbObject<? super T>>
implements DbObjectCollection<T> {
    private static final long serialVersionUID = 4540018510759477211L;
    protected ArrayList<T> inner = new ArrayList();
    private DbCommonObject<?> parent = null;
    private transient boolean validateAtChange = true;
    private transient AddDbObjectPredicate addDbObjectPredicate = (p, c) -> true;
    protected String SIMPLE_NAME = AbstractBaseDbObjectCollection.getSimpleName(this.getClass());
    private static final Map<Class<?>, String> CACHE = new HashMap();
    private static final Map<Class<?>, Class<?>> COLLECTION_TYPE_CACHE = new HashMap();

    protected AbstractBaseDbObjectCollection() {
    }

    protected AbstractBaseDbObjectCollection(DbCommonObject<?> parent) {
        this.parent = parent;
    }

    protected AddDbObjectPredicate getAddDbObjectPredicate() {
        if (this.addDbObjectPredicate == null) {
            this.addDbObjectPredicate = (p, c) -> true;
        }
        return this.addDbObjectPredicate;
    }

    public void setAddDbObjectPredicate(AddDbObjectPredicate addDbObjectPredicate) {
        this.addDbObjectPredicate = addDbObjectPredicate;
    }

    protected boolean isValidateAtChange() {
        return this.validateAtChange;
    }

    protected void setValidateAtChange(boolean validateAtChange) {
        this.validateAtChange = validateAtChange;
    }

    protected DbCommonObject<?> getParent() {
        return this.parent;
    }

    protected <S extends AbstractBaseDbObjectCollection<?>> S setParent(DbCommonObject<?> parent) {
        this.parent = (DbCommonObject)CommonUtils.cast(parent);
        return (S)this;
    }

    protected boolean beforeAdd(T args) {
        return true;
    }

    protected void afterAdd(T args) {
    }

    protected boolean beforeRemove(T args) {
        return true;
    }

    protected void afterRemove(T args) {
    }

    public T getById(String id) {
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            AbstractBaseDbObject t = (AbstractBaseDbObject)this.inner.get(i);
            if (!CommonUtils.eq(t.getId(), id)) continue;
            this.setElementParent(t);
            return (T)t;
        }
        return null;
    }

    protected void renew() {
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            AbstractBaseDbObject obj = (AbstractBaseDbObject)this.inner.get(i);
            obj.setOrdinal(i);
        }
    }

    @Override
    public boolean add(T e) {
        if (!this.getAddDbObjectPredicate().test(this, e)) {
            return false;
        }
        boolean bool = false;
        if (!this.beforeAdd(e)) {
            return false;
        }
        this.setElementParent(e);
        bool = this.inner.add(e);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        this.afterAdd(e);
        ((AbstractBaseDbObject)e).validate();
        return bool;
    }

    protected void setElementParent(T e) {
        ((AbstractBaseDbObject)e).setParent(this);
    }

    @Override
    public void add(int index, T element) {
        if (!this.getAddDbObjectPredicate().test(this, element)) {
            return;
        }
        if (!this.beforeAdd(element)) {
            return;
        }
        this.setElementParent(element);
        if (this.inner.contains(element)) {
            return;
        }
        this.inner.add(index, element);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        this.afterAdd(element);
        ((AbstractBaseDbObject)element).validate();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Set<int> set = CommonUtils.set(c.size());
        for (AbstractBaseDbObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t) || this.beforeAdd(t)) continue;
            set.add((int)t);
        }
        boolean bool = false;
        for (AbstractBaseDbObject t : c) {
            AbstractBaseDbObject findObj;
            if (!this.getAddDbObjectPredicate().test(this, t) || set.contains(t) || (findObj = this.find((T)t)) != null) continue;
            bool = this.inner.add(t);
            this.setElementParent(t);
        }
        this.renew();
        for (AbstractBaseDbObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t) || set.contains(t)) continue;
            this.afterAdd(t);
        }
        return bool;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this == c) {
            return false;
        }
        Set<int> set = CommonUtils.set(c.size());
        for (AbstractBaseDbObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t) || this.beforeAdd(t)) continue;
            set.add((int)t);
        }
        boolean bool = false;
        for (AbstractBaseDbObject t : c) {
            AbstractBaseDbObject findObj;
            if (!this.getAddDbObjectPredicate().test(this, t) || set.contains(t) || (findObj = this.find((T)t)) != null) continue;
            bool = this.inner.add(t);
            this.setElementParent(t);
        }
        this.renew();
        for (AbstractBaseDbObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t) || set.contains(t)) continue;
            this.afterAdd(t);
        }
        return bool;
    }

    @Override
    public boolean containsAll(Collection<?> args) {
        for (Object arg : args) {
            if (this.contains((AbstractBaseDbObject)arg)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.beforeRemove((AbstractBaseDbObject)o);
        boolean bool = this.inner.remove(o);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        if (bool) {
            ((AbstractBaseDbObject)o).setParent(null);
        }
        this.afterRemove((AbstractBaseDbObject)o);
        return bool;
    }

    @Override
    public T remove(int index) {
        Object obj = this.get(index);
        this.beforeRemove(obj);
        AbstractBaseDbObject rm = (AbstractBaseDbObject)this.inner.remove(index);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        if (rm != null) {
            rm.setParent(null);
        }
        this.afterRemove(obj);
        return (T)obj;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = true;
        for (Object o : c) {
            boolean bool = this.inner.remove(o);
            if (!bool) {
                result = false;
                continue;
            }
            ((AbstractBaseDbObject)o).setParent(null);
        }
        this.renew();
        return result;
    }

    @Override
    public T set(int index, T element) {
        AbstractBaseDbObject obj = (AbstractBaseDbObject)this.inner.set(index, element);
        ((AbstractBaseDbObject)element).setOrdinal(index);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        return (T)obj;
    }

    public String toString() {
        SeparatedStringBuilder builder = new SeparatedStringBuilder("\n");
        builder.add(this.inner);
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        return this.toString();
    }

    public AbstractBaseDbObjectCollection<T> clone() {
        AbstractBaseDbObjectCollection clone = (AbstractBaseDbObjectCollection)this.newInstance().get();
        List clones = CommonUtils.list();
        for (AbstractBaseDbObject obj : this) {
            clones.add(obj.clone());
        }
        clone.addAll(clones);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, EqualsHandler.getInstance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (equalsHandler.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof AbstractBaseDbObjectCollection)) {
            return false;
        }
        AbstractBaseDbObjectCollection val = (AbstractBaseDbObjectCollection)obj;
        if (!this.equalsElements(val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    private boolean equalsElements(AbstractBaseDbObjectCollection<T> val, EqualsHandler equalsHandler) {
        if (!equalsHandler.valueEquals("size", this, val, this.inner.size(), val.inner.size(), EqualsUtils.getEqualsSupplier(this.inner.size(), val.inner.size()))) {
            return false;
        }
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            AbstractBaseDbObject thisObj1 = (AbstractBaseDbObject)this.inner.get(i);
            AbstractBaseDbObject thisObj2 = null;
            if (i < val.inner.size()) {
                thisObj2 = (AbstractBaseDbObject)val.inner.get(i);
            }
            if (this.equalsElement(thisObj1, thisObj2, equalsHandler)) continue;
            return false;
        }
        return true;
    }

    protected boolean likeElement(T t1, T t2, EqualsHandler equalsHandler) {
        if (t1 == null) {
            return t2 == null;
        }
        return ((AbstractBaseDbObject)t1).like(t2, equalsHandler);
    }

    protected boolean equalsElement(T t1, T t2, EqualsHandler equalsHandler) {
        if (t1 == null) {
            return t2 == null;
        }
        return ((AbstractBaseDbObject)t1).equals(t2, equalsHandler);
    }

    protected boolean equals(String propertyName, T target1, T target2, Object value1, Object value2, EqualsHandler equalsHandler) {
        return equalsHandler.valueEquals(propertyName, target1, target2, value1, value2, EqualsUtils.getEqualsSupplier(value1, value2));
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.inner);
        return builder.hashCode();
    }

    @Override
    public void loadXml(Reader reader, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(reader);
        AbstractBaseDbObjectCollectionXmlReaderHandler<?> handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    @Override
    public void loadXml(InputStream stream, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(stream);
        AbstractBaseDbObjectCollectionXmlReaderHandler<?> handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(String path, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        InputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = FileUtils.getInputStream(path);
            if (stream == null) {
                throw new FileNotFoundException("path=" + path);
            }
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        finally {
            FileUtils.close(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(File file, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        FileInputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = new FileInputStream(file);
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    protected AbstractBaseDbObjectCollectionXmlReaderHandler<?> getDbObjectXmlReaderHandler() {
        if (this instanceof NewElement) {
            NewElement newElement = (NewElement)((Object)this);
            final AbstractBaseDbObject dbObject = (AbstractBaseDbObject)newElement.newElement();
            return new AbstractBaseDbObjectCollectionXmlReaderHandler(this.newInstance()){

                @Override
                protected void initializeSetValue() {
                    super.initializeSetValue();
                    this.setChild(dbObject.getDbObjectXmlReaderHandler());
                }
            };
        }
        return null;
    }

    @Override
    public void writeXml(OutputStream stream) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(stream){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(Writer writer) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(writer){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(StaxWriter stax) throws XMLStreamException {
        this.writeXml(this.getSimpleName(), stax);
    }

    public void writeXml(String name, StaxWriter stax) throws XMLStreamException {
        int size = this.size();
        stax.newLine();
        stax.indent();
        stax.writeStartElement(name);
        this.writeXmlOptionalAttributes(stax);
        stax.addIndentLevel(1);
        for (int i = 0; i < size; ++i) {
            Object obj = this.get(i);
            ((AbstractBaseDbObject)obj).writeXml(stax);
        }
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
    }

    @Override
    public void writeXml(String path) throws XMLStreamException, IOException {
        this.writeXml(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(File file) throws XMLStreamException, IOException {
        FileOutputStream fos = null;
        BufferedOutputStream stream = null;
        try {
            fos = new FileOutputStream(file);
            stream = new BufferedOutputStream(fos);
            StaxWriter stax = new StaxWriter(stream);
            this.writeXml(stax);
            stream.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            FileUtils.close(fos);
            throw throwable;
        }
        FileUtils.close(stream);
        FileUtils.close(fos);
    }

    protected String getSimpleName() {
        return this.SIMPLE_NAME;
    }

    public static String getSimpleName(Class<?> clazz) {
        String name = CACHE.get(clazz);
        if (name != null) {
            return name;
        }
        name = AbstractBaseDbObjectCollection.getSimpleNameNoCache(clazz);
        CACHE.put(clazz, name);
        return name;
    }

    private static String getSimpleNameNoCache(Class<?> clazz) {
        if (clazz == ReferenceColumnCollection.class) {
            return "columns";
        }
        if (clazz == DimensionLevelColumnCollection.class) {
            return "columns";
        }
        return StringUtils.uncapitalize(SchemaUtils.getPluralName(clazz));
    }

    protected void cloneProperties(AbstractBaseDbObjectCollection<T> obj) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            obj.add(((AbstractBaseDbObject)this.get(i)).clone());
        }
    }

    @Override
    public DbObjectDifferenceCollection diff(DbObjectCollection<T> obj) {
        DbObjectDifferenceCollection diff = new DbObjectDifferenceCollection(this, obj);
        return diff;
    }

    @Override
    public DbObjectDifferenceCollection diff(DbObjectCollection<T> obj, EqualsHandler equalsHandler) {
        DbObjectDifferenceCollection diff = new DbObjectDifferenceCollection(this, (DbObjectCollection<?>)obj, equalsHandler);
        return diff;
    }

    protected void setDiffAll(SeparatedStringBuilder builder) {
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.inner.retainAll(c);
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public T get(int index) {
        AbstractBaseDbObject ret = (AbstractBaseDbObject)this.inner.get(index);
        if (ret != null) {
            this.setElementParent(ret);
        }
        return (T)ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.inner.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.inner.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.inner.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.inner.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.inner.subList(fromIndex, toIndex);
    }

    protected void validate() {
        if (this.isValidateAtChange()) {
            this.renew();
        }
        this.validateAllElement();
    }

    protected void validateAllElement() {
        for (AbstractBaseDbObject obj : this.inner) {
            obj.validate();
        }
    }

    @Override
    public void sort() {
        if (!(this instanceof UnOrdered)) {
            Collections.sort(this.inner);
        }
        this.renew();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        Collections.sort(this.inner, comparator);
        this.renew();
    }

    @Override
    public Class<T> getType() {
        Class<?> clazz = this.getClass();
        Class typeClazz = COLLECTION_TYPE_CACHE.get(clazz);
        if (typeClazz != null) {
            return typeClazz;
        }
        Type type = clazz.getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        Type[] aTypes = pType.getActualTypeArguments();
        typeClazz = (Class)aTypes[0];
        COLLECTION_TYPE_CACHE.put(clazz, typeClazz);
        return typeClazz;
    }

    @Override
    public T find(T obj) {
        if (obj == null) {
            return null;
        }
        for (AbstractBaseDbObject val : this.inner) {
            if (!val.like(obj)) continue;
            return (T)val;
        }
        return null;
    }

    @Override
    public T find(Object obj) {
        return (T)this.find((T)((AbstractBaseDbObject)obj));
    }

    @Override
    public void applyAll(Consumer<DbObject<?>> consumer) {
        this.equals(this, new GetAllDbObjectEqualsHandler(consumer));
    }

    protected boolean equals(String propertyName, List<T> target, Object value, Object targetValue, EqualsHandler equalsHandler) {
        return equalsHandler.valueEquals(propertyName, this, target, value, targetValue, EqualsUtils.getEqualsSupplier(value, targetValue));
    }

    protected boolean equals(ISchemaProperty props, List<T> target, EqualsHandler equalsHandler) {
        return this.equals(props.getLabel(), target, props.getValue(this), props.getValue(target), equalsHandler);
    }

    protected abstract Supplier<? extends DbObjectCollection<T>> newInstance();
}

