/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.CaseSensitiveProperty;
import com.sqlapp.data.schemas.properties.DefinitionProperty;
import com.sqlapp.data.schemas.properties.DisplayNameProperty;
import com.sqlapp.data.schemas.properties.DisplayRemarksProperty;
import com.sqlapp.data.schemas.properties.ErrorMessagesProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.RemarksProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.data.schemas.properties.StatementProperty;
import com.sqlapp.data.schemas.properties.ValidProperty;
import com.sqlapp.data.schemas.properties.VirtualProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractNamedObject<T extends AbstractNamedObject<T>>
extends AbstractDbObject<T>
implements Serializable,
Cloneable,
NameProperty<T>,
DisplayNameProperty<T>,
DefinitionProperty<T>,
StatementProperty<T>,
ErrorMessagesProperty<T>,
RemarksProperty<T>,
DisplayRemarksProperty<T>,
VirtualProperty<T>,
ValidProperty<T>,
CaseSensitiveProperty<T> {
    private static final long serialVersionUID = 210101856540540272L;
    private String name = null;
    private String displayName = null;
    private String displayRemarks = null;
    private String remarks = null;
    private List<String> definition = null;
    private List<String> statement = null;
    private List<String> errorMessages = null;
    private boolean caseSensitive = (Boolean)SchemaProperties.CASE_SENSITIVE.getDefaultValue();
    private boolean valid = (Boolean)SchemaProperties.VALID.getDefaultValue();
    private boolean virtual = (Boolean)SchemaProperties.VIRTUAL.getDefaultValue();

    protected AbstractNamedObject() {
    }

    protected AbstractNamedObject(String name) {
        this.setName(name);
    }

    protected AbstractNamedObject(String name, String specificName) {
        this.name = CommonUtils.trim(name).intern();
        if (this.hasSpecificNameProperty()) {
            this.toSpecificNameProperty().setSpecificName(specificName);
        }
    }

    protected boolean hasSpecificNameProperty() {
        return this instanceof SpecificNameProperty;
    }

    protected SpecificNameProperty<?> toSpecificNameProperty() {
        return (SpecificNameProperty)((Object)this);
    }

    protected String getSpecificName() {
        return this.getName();
    }

    protected T setSpecificName(String specificName) {
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.getParent() == null) {
            return this.caseSensitive;
        }
        if (this.getParent() instanceof CaseSensitiveProperty) {
            return ((CaseSensitiveProperty)((Object)this.getParent())).isCaseSensitive();
        }
        return this.caseSensitive;
    }

    @Override
    public T setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T setName(String name) {
        if (name == null) {
            this.name = null;
            return (T)this;
        }
        this.name = CommonUtils.trim(name).intern();
        DbCommonObject<?> parent = this.getParent();
        if (parent != null && parent instanceof AbstractDbObjectCollection) {
            DbCommonObject<?> dbCommonObject = parent;
            synchronized (dbCommonObject) {
                ((AbstractDbObjectCollection)parent).renew();
            }
        }
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public T setDisplayName(String displayName) {
        this.displayName = displayName;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public String getDisplayRemarks() {
        return this.displayRemarks;
    }

    @Override
    public T setDisplayRemarks(String displayRemarks) {
        this.displayRemarks = displayRemarks;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(!this.isCaseSensitive());
        builder.append(this.getName());
        builder.append(this.getSpecificName());
        return builder.hashCode();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof AbstractNamedObject)) {
            return false;
        }
        AbstractNamedObject val = (AbstractNamedObject)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DISPLAY_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DISPLAY_REMARKS, val, equalsHandler)) {
            return false;
        }
        if (this.hasSpecificNameProperty() && !this.equals(SchemaProperties.SPECIFIC_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.VALID, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.VIRTUAL, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.REMARKS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.STATEMENT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFINITION, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.ERROR_MESSAGES, val, equalsHandler);
    }

    @Override
    public boolean like(Object obj) {
        return this.equals(obj, IncludeFilterEqualsHandler.EQUALS_NAME_HANDLER);
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        builder.add(SchemaProperties.DISPLAY_NAME.getLabel(), this.getDisplayName());
        if (this.hasSpecificNameProperty() && !CommonUtils.eq(this.getName(), this.toSpecificNameProperty().getSpecificName())) {
            builder.add(SchemaProperties.SPECIFIC_NAME.getLabel(), this.toSpecificNameProperty().getSpecificName());
        }
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        builder.add(SchemaProperties.DISPLAY_NAME.getLabel(), this.getDisplayName());
        if (!CommonUtils.eq(this.getName(), this.getSpecificName()) && this.getSpecificName() != null) {
            builder.add(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
        return builder.toString();
    }

    protected abstract void toStringDetail(ToStringBuilder var1);

    @Override
    protected void toString(ToStringBuilder builder) {
        this.toStringDetail(builder);
        super.toString(builder);
        if (!this.isValid()) {
            builder.add((ISchemaProperty)SchemaProperties.VALID, (Object)this.isValid());
        }
        builder.add((ISchemaProperty)SchemaProperties.REMARKS, this.getRemarks());
        builder.add((ISchemaProperty)SchemaProperties.DISPLAY_REMARKS, this.getDisplayRemarks());
        builder.add((ISchemaProperty)SchemaProperties.STATEMENT, this.getStatement());
        builder.add((ISchemaProperty)SchemaProperties.DEFINITION, this.getDefinition());
        builder.add((ISchemaProperty)SchemaProperties.VIRTUAL, (Object)this.isVirtual());
        builder.add((ISchemaProperty)SchemaProperties.ERROR_MESSAGES, this.getErrorMessages());
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public T setRemarks(String remarks) {
        this.remarks = CommonUtils.emptyToNull(remarks);
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public List<String> getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = CommonUtils.list();
        }
        return this.errorMessages;
    }

    @Override
    public T setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public T setValid(boolean valid) {
        this.valid = valid;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public T setVirtual(boolean virtual) {
        this.virtual = virtual;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public List<String> getDefinition() {
        if (this.definition == null) {
            this.definition = CommonUtils.list();
        }
        return this.definition;
    }

    @Override
    public T setDefinition(List<String> definition) {
        this.definition = definition;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    public List<String> getStatement() {
        if (this.statement == null) {
            this.statement = CommonUtils.list();
        }
        return this.statement;
    }

    @Override
    public T setStatement(List<String> statement) {
        this.statement = statement;
        return (T)((AbstractNamedObject)this.instance());
    }

    @Override
    protected void writeName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.NAME.getLabel(), this.getName());
        stax.writeAttribute(SchemaProperties.DISPLAY_NAME.getLabel(), this.getDisplayName());
        if (!CommonUtils.eq(this.getName(), this.getSpecificName())) {
            stax.writeAttribute(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
    }

    @Override
    protected void writeCommonAttribute(StaxWriter stax) throws XMLStreamException {
        super.writeCommonAttribute(stax);
        if (!this.isValid()) {
            stax.writeAttribute(SchemaProperties.VALID.getLabel(), (Object)this.isValid());
        }
        if (this.isVirtual()) {
            stax.writeAttribute(SchemaProperties.VIRTUAL.getLabel(), (Object)this.isVirtual());
        }
        if (!this.needsEscape(this.getRemarks())) {
            stax.writeAttribute(SchemaProperties.REMARKS.getLabel(), this.getRemarks());
        }
        if (!this.needsEscape(this.getDisplayRemarks())) {
            stax.writeAttribute(SchemaProperties.DISPLAY_REMARKS.getLabel(), this.getDisplayRemarks());
        }
    }

    @Override
    protected void writeCommonValue(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.getStatement())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.STATEMENT.getLabel(), this.listToString(this.getStatement()));
        }
        if (!CommonUtils.isEmpty(this.getDefinition())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.DEFINITION.getLabel(), this.listToString(this.getDefinition()));
        }
        if (this.needsEscape(this.getRemarks())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.REMARKS.getLabel(), this.getRemarks());
        }
        if (this.needsEscape(this.getDisplayRemarks())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.DISPLAY_REMARKS.getLabel(), this.getDisplayRemarks());
        }
        if (!CommonUtils.isEmpty(this.getErrorMessages())) {
            stax.newLine();
            stax.indent();
            stax.writeElement(SchemaProperties.ERROR_MESSAGES.getLabel(), this.getErrorMessages());
        }
        super.writeCommonValue(stax);
    }

    @Override
    public int compareTo(T o) {
        if (o == null) {
            return 1;
        }
        int ret = CommonUtils.compare((Comparable)((Object)this.getName()), (Object)((AbstractNamedObject)o).getName());
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getSpecificName()), (Object)((AbstractNamedObject)o).getSpecificName());
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getDisplayName()), (Object)((AbstractNamedObject)o).getDisplayName());
        return ret;
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<T> getDbObjectXmlReaderHandler() {
        return new AbstractNamedObjectXmlReaderHandler(this.newInstance()){};
    }
}

