/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.Partitioning;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.SubPartition;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.CompressionProperty;
import com.sqlapp.data.schemas.properties.CompressionTypeProperty;
import com.sqlapp.data.schemas.properties.HighValueInclusiveProperty;
import com.sqlapp.data.schemas.properties.HighValueProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LowValueInclusiveProperty;
import com.sqlapp.data.schemas.properties.LowValueProperty;
import com.sqlapp.data.schemas.properties.complex.IndexTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.LobTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.TableSpaceProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractPartition<T extends AbstractPartition<T>>
extends AbstractSchemaObject<T>
implements CompressionProperty<T>,
CompressionTypeProperty<T>,
LowValueProperty<T>,
HighValueProperty<T>,
LowValueInclusiveProperty<T>,
HighValueInclusiveProperty<T>,
TableSpaceProperty<T>,
IndexTableSpaceProperty<T>,
LobTableSpaceProperty<T> {
    private static final long serialVersionUID = -3887238098717065317L;
    private String lowValue = null;
    private boolean lowValueInclusive = (Boolean)SchemaProperties.LOW_VALUE_INCLUSIVE.getDefaultValue();
    private String highValue = null;
    private boolean highValueInclusive = (Boolean)SchemaProperties.HIGH_VALUE_INCLUSIVE.getDefaultValue();
    private boolean compression = (Boolean)SchemaProperties.COMPRESSION.getDefaultValue();
    private String compressionType = null;
    private final TableSpace tableSpace = null;
    private final TableSpace lobTableSpace = null;
    private final TableSpace indexTableSpace = null;

    public AbstractPartition() {
    }

    public AbstractPartition(String partitionName) {
        super(partitionName);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.LOW_VALUE, this.getLowValue());
        if (this.getLowValue() != null) {
            builder.add((ISchemaProperty)SchemaProperties.LOW_VALUE_INCLUSIVE, (Object)this.isLowValueInclusive());
        }
        builder.add((ISchemaProperty)SchemaProperties.HIGH_VALUE, this.getHighValue());
        if (this.getHighValue() != null) {
            builder.add((ISchemaProperty)SchemaProperties.HIGH_VALUE_INCLUSIVE, (Object)this.isHighValueInclusive());
        }
        if (this.compression) {
            builder.add((ISchemaProperty)SchemaProperties.COMPRESSION, (Object)this.compression);
            builder.add((ISchemaProperty)SchemaProperties.COMPRESSION_TYPE, this.compressionType);
        }
        builder.add((ISchemaProperty)SchemaProperties.TABLE_SPACE_NAME, this.getTableSpaceName());
        builder.add((ISchemaProperty)SchemaProperties.LOB_TABLE_SPACE_NAME, this.getLobTableSpaceName());
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TABLE_SPACE_NAME, this.getIndexTableSpaceName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AbstractPartition)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        AbstractPartition val = (AbstractPartition)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.LOW_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!(this.getLowValue() == null && val.getLowValue() == null || this.equals(SchemaProperties.LOW_VALUE_INCLUSIVE, val, equalsHandler))) {
            return false;
        }
        if (!this.equals(SchemaProperties.HIGH_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!(this.getHighValue() == null && val.getHighValue() == null || this.equals(SchemaProperties.HIGH_VALUE_INCLUSIVE, val, equalsHandler))) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOB_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.SUB_PARTITIONS, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.LOW_VALUE.getLabel(), this.getLowValue());
        if (this.getLowValue() != null) {
            stax.writeAttribute(SchemaProperties.LOW_VALUE_INCLUSIVE.getLabel(), (Object)this.isLowValueInclusive());
        }
        stax.writeAttribute(SchemaProperties.HIGH_VALUE.getLabel(), this.getHighValue());
        if (this.getHighValue() != null) {
            stax.writeAttribute(SchemaProperties.HIGH_VALUE_INCLUSIVE.getLabel(), (Object)this.isHighValueInclusive());
        }
        if (this.isCompression()) {
            stax.writeAttribute(SchemaProperties.COMPRESSION.getLabel(), (Object)this.isCompression());
            stax.writeAttribute(SchemaProperties.COMPRESSION_TYPE.getLabel(), this.getCompressionType());
        }
        stax.writeAttribute(SchemaProperties.TABLE_SPACE_NAME.getLabel(), this.getTableSpaceName());
        stax.writeAttribute(SchemaProperties.LOB_TABLE_SPACE_NAME.getLabel(), this.getLobTableSpaceName());
        stax.writeAttribute(SchemaProperties.INDEX_TABLE_SPACE_NAME.getLabel(), this.getIndexTableSpaceName());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
    }

    @Override
    protected void cloneProperties(T clone) {
        super.cloneProperties(clone);
    }

    @Override
    public String getLowValue() {
        return this.lowValue;
    }

    @Override
    public T setLowValue(String lowValue) {
        this.lowValue = lowValue;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public boolean isLowValueInclusive() {
        return this.lowValueInclusive;
    }

    @Override
    public T setLowValueInclusive(boolean lowValueInclusive) {
        this.lowValueInclusive = lowValueInclusive;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public String getHighValue() {
        return this.highValue;
    }

    @Override
    public T setHighValue(String highValue) {
        this.highValue = highValue;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public boolean isHighValueInclusive() {
        return this.highValueInclusive;
    }

    @Override
    public T setHighValueInclusive(boolean highValueInclusive) {
        this.highValueInclusive = highValueInclusive;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public T setCompression(boolean compression) {
        this.compression = compression;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public T setCompressionType(String compressionType) {
        this.compressionType = compressionType;
        return (T)((AbstractPartition)this.instance());
    }

    @Override
    public String getCompressionType() {
        return this.compressionType;
    }

    public Partitioning getPartitioning() {
        return this.getAncestor(Partitioning.class);
    }

    public Partition toPartition() {
        if (this instanceof Partition) {
            return (Partition)this;
        }
        Partition partition = new Partition();
        SchemaUtils.copySchemaProperties(this, partition);
        return partition;
    }

    public SubPartition toSubPartition() {
        if (this instanceof SubPartition) {
            return (SubPartition)this;
        }
        SubPartition partition = new SubPartition();
        SchemaUtils.copySchemaProperties(this, partition);
        return partition;
    }
}

