/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DummyPrincipal;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.Principal;
import com.sqlapp.data.schemas.PrivilegeState;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.GrantableProperty;
import com.sqlapp.data.schemas.properties.GranteeNameProperty;
import com.sqlapp.data.schemas.properties.GrantorNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PrivilegeProperty;
import com.sqlapp.data.schemas.properties.PrivilegeStateProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

abstract class AbstractPrivilege<T extends AbstractPrivilege<T>>
extends AbstractDbObject<T>
implements Comparable<T>,
GrantorNameProperty<T>,
GranteeNameProperty<T>,
PrivilegeProperty<T>,
GrantableProperty<T>,
PrivilegeStateProperty<T> {
    private static final long serialVersionUID = 1L;
    private User grantor;
    private Principal<?> grantee;
    private String privilege;
    private PrivilegeState state = null;
    private boolean grantable = (Boolean)SchemaProperties.GRANTABLE.getDefaultValue();
    private static final EqualsHandler LIKE_EQUALS_HANDLER = new IncludeFilterEqualsHandler(SchemaProperties.PRIVILEGE.getLabel(), SchemaProperties.GRANTEE_NAME.getLabel());

    AbstractPrivilege() {
    }

    public User getGrantor() {
        return this.grantor;
    }

    public T setGrantor(User grantor) {
        this.grantor = this.getGrantorFromParent(grantor);
        return (T)((AbstractPrivilege)this.instance());
    }

    @Override
    public T setGrantorName(String grantor) {
        if (grantor == null) {
            return this.setGrantor(null);
        }
        return this.setGrantor(new User(grantor));
    }

    @Override
    protected AbstractDbObjectCollection<?> getParent() {
        return (AbstractDbObjectCollection)super.getParent();
    }

    protected User getGrantorFromParent(User grantor) {
        if (grantor == null) {
            return grantor;
        }
        if (this.getParent() == null) {
            return grantor;
        }
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return grantor;
        }
        User getUser = (User)catalog.getUsers().get(grantor.getName());
        if (getUser != null) {
            return getUser;
        }
        return grantor;
    }

    @Override
    public String getGrantorName() {
        if (this.grantor == null) {
            return null;
        }
        return this.grantor.getName();
    }

    public <S extends Principal<?>> S getGrantee() {
        return (S)this.grantee;
    }

    @Override
    public String getGranteeName() {
        if (this.grantee == null) {
            return null;
        }
        return this.grantee.getName();
    }

    public T setGrantee(Principal<?> grantee) {
        this.grantee = this.getGranteeFromParent(grantee);
        return (T)((AbstractPrivilege)this.instance());
    }

    @Override
    public T setGranteeName(String grantee) {
        return this.setGrantee(new DummyPrincipal(grantee));
    }

    protected Principal<?> getGranteeFromParent(Principal<?> grantee) {
        if (grantee == null) {
            return grantee;
        }
        if (this.getParent() == null) {
            return grantee;
        }
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return grantee;
        }
        User getUser = (User)catalog.getUsers().get(grantee.getName());
        if (getUser != null) {
            return getUser;
        }
        Role getRole = (Role)catalog.getRoles().get(grantee.getName());
        if (getRole != null) {
            return getRole;
        }
        return grantee;
    }

    @Override
    public String getPrivilege() {
        return this.privilege;
    }

    @Override
    public T setPrivilege(String privilege) {
        this.privilege = privilege;
        return (T)((AbstractPrivilege)this.instance());
    }

    @Override
    public boolean isGrantable() {
        return this.grantable;
    }

    @Override
    public T setGrantable(boolean grantable) {
        this.grantable = grantable;
        return (T)((AbstractPrivilege)this.instance());
    }

    @Override
    public PrivilegeState getState() {
        return this.state;
    }

    @Override
    public T setState(PrivilegeState privilegeState) {
        this.state = privilegeState;
        return (T)((AbstractPrivilege)this.instance());
    }

    protected abstract void writeAttributeXml(StaxWriter var1) throws XMLStreamException;

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.GRANTOR_NAME.getLabel(), this.getGrantorName());
        stax.writeAttribute(SchemaProperties.GRANTEE_NAME.getLabel(), this.getGranteeName());
        this.writeAttributeXml(stax);
        stax.writeAttribute(SchemaProperties.PRIVILEGE.getLabel(), this.getPrivilege());
        stax.writeAttribute(SchemaProperties.PRIVILEGE_STATE.getLabel(), (Object)this.getState());
        if (this.isGrantable()) {
            stax.writeAttribute(SchemaProperties.GRANTABLE.getLabel(), (Object)this.isGrantable());
        }
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.GRANTOR_NAME, this.getGrantorName());
        builder.add((ISchemaProperty)SchemaProperties.GRANTEE_NAME, this.getGranteeName());
        builder.add((ISchemaProperty)SchemaProperties.PRIVILEGE, this.getPrivilege());
        builder.add((ISchemaProperty)SchemaProperties.PRIVILEGE_STATE, (Object)this.getState());
        builder.add((ISchemaProperty)SchemaProperties.GRANTABLE, (Object)this.isGrantable());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof AbstractPrivilege)) {
            return false;
        }
        AbstractPrivilege val = (AbstractPrivilege)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.GRANTOR_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.GRANTEE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRIVILEGE, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getPrivilege(), val.getPrivilege()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRIVILEGE_STATE, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.GRANTABLE, val, equalsHandler);
    }

    @Override
    public boolean like(Object obj) {
        return this.equals(obj, LIKE_EQUALS_HANDLER);
    }

    @Override
    public int compareTo(T o) {
        int ret = CommonUtils.compare((Comparable)((Object)this.getGrantorName()), (Object)((AbstractPrivilege)o).getGrantorName());
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getGranteeName()), (Object)((AbstractPrivilege)o).getGranteeName());
        if (ret != 0) {
            return ret;
        }
        return CommonUtils.compare((Comparable)((Object)this.getPrivilege()), (Object)((AbstractPrivilege)o).getPrivilege());
    }

    @Override
    protected void validate() {
        if (this.grantee != null && this.grantee.getParent() == null) {
            this.grantee = this.getGranteeFromParent(this.grantee);
        }
        if (this.grantor != null && this.grantor.getParent() == null) {
            this.grantor = this.getGrantorFromParent(this.grantor);
        }
    }
}

