/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AssemblyCollection;
import com.sqlapp.data.schemas.AssemblyFile;
import com.sqlapp.data.schemas.AssemblyFileCollection;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PermissionSetProperty;
import com.sqlapp.data.schemas.properties.object.AssemblyFilesProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.Locale;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class Assembly
extends AbstractNamedObject<Assembly>
implements HasParent<AssemblyCollection>,
PermissionSetProperty<Assembly>,
AssemblyFilesProperty<Assembly> {
    private static final long serialVersionUID = 1L;
    private AssemblyFileCollection assemblyFiles = new AssemblyFileCollection(this);
    private PermissionSet permissionSet = null;

    public Assembly() {
    }

    public Assembly(String name) {
        super(name);
    }

    @Override
    protected Supplier<Assembly> newInstance() {
        return () -> new Assembly();
    }

    @Override
    public String getSpecificName() {
        return this.getName();
    }

    public AssemblyFile newAssemblyFile() {
        AssemblyFile file = new AssemblyFile();
        file.setParent(this.assemblyFiles);
        return file;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Assembly)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Assembly val = (Assembly)CommonUtils.cast(obj);
        if (!this.equals(SchemaObjectProperties.ASSEMBLY_FILES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PERMISSION_SET, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.PERMISSION_SET.getLabel(), (Object)this.getPermissionSet());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.assemblyFiles)) {
            this.assemblyFiles.writeXml(stax);
        }
    }

    protected void setAssemblyFiles(AssemblyFileCollection assemblyFiles) {
        this.assemblyFiles = assemblyFiles;
        if (this.assemblyFiles != null) {
            this.assemblyFiles.setParent(this);
        }
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaObjectProperties.ASSEMBLY_FILES, (Object)this.getAssemblyFiles());
        builder.add((ISchemaProperty)SchemaProperties.PERMISSION_SET, (Object)this.getPermissionSet());
    }

    @Override
    public AssemblyFileCollection getAssemblyFiles() {
        return this.assemblyFiles;
    }

    @Override
    public PermissionSet getPermissionSet() {
        return this.permissionSet;
    }

    @Override
    public Assembly setPermissionSet(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
        return this;
    }

    @Override
    public AssemblyCollection getParent() {
        return (AssemblyCollection)super.getParent();
    }

    public static enum PermissionSet implements EnumProperties
    {
        Safe,
        External,
        Unsafe;


        @Override
        public String getDisplayName() {
            return this.getDisplayName(Locale.ENGLISH);
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.toString();
        }

        @Override
        public String getSqlValue() {
            return this.toString().toUpperCase();
        }

        public static PermissionSet parse(String value) {
            if (value == null) {
                return null;
            }
            if (value.toUpperCase().startsWith("S")) {
                return Safe;
            }
            if (value.toUpperCase().startsWith("U")) {
                return Unsafe;
            }
            if (value.toUpperCase().startsWith("E")) {
                return External;
            }
            return null;
        }
    }
}

