/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AssemblyFileCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ContentProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.BinaryUtils;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.io.UnsupportedEncodingException;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class AssemblyFile
extends AbstractNamedObject<AssemblyFile>
implements HasParent<AssemblyFileCollection>,
ContentProperty<AssemblyFile> {
    private static final long serialVersionUID = 5364113040918889046L;
    private byte[] content = null;
    private static final String ENCODE = "UTF-8";

    public AssemblyFile() {
    }

    public AssemblyFile(String filePath) {
        super(filePath);
    }

    @Override
    protected Supplier<AssemblyFile> newInstance() {
        return () -> new AssemblyFile();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AssemblyFile)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        AssemblyFile val = (AssemblyFile)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.CONTENT, val, equalsHandler, EqualsUtils.getEqualsSupplier(this.getContent(), val.getContent()))) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.CONTENT, BinaryUtils.toHexString(this.getContent()));
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public AssemblyFile setContent(byte ... content) {
        this.content = content;
        return this;
    }

    @Override
    public AssemblyFile setContent(String value) {
        return this.setContent(this.toBinary(value));
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        try {
            if (AssemblyFile.isSource(this.getName())) {
                stax.writeCData(SchemaProperties.CONTENT.getLabel(), new String(this.getContent(), ENCODE));
            } else {
                stax.writeCData(SchemaProperties.CONTENT.getLabel(), BinaryUtils.encodeBase64(this.getContent()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getContentAsSource() throws UnsupportedEncodingException {
        if (AssemblyFile.isSource(this.getName())) {
            return new String(this.getContent(), ENCODE);
        }
        return null;
    }

    public boolean isSourceFile() {
        return AssemblyFile.isSource(this.getName());
    }

    protected static boolean isSource(String filePath) {
        if (filePath == null) {
            return false;
        }
        String extension = FileUtils.getExtension(filePath);
        if (CommonUtils.isEmpty(extension)) {
            return false;
        }
        if ("pdb".equalsIgnoreCase(extension)) {
            return false;
        }
        return !"dll".equalsIgnoreCase(extension);
    }

    protected static String toSource(AssemblyFile assemblyFile) {
        if (assemblyFile == null) {
            return null;
        }
        if (CommonUtils.isEmpty(assemblyFile.getContent())) {
            return null;
        }
        if (assemblyFile.isSourceFile()) {
            try {
                return new String(assemblyFile.getContent(), ENCODE);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private byte[] toBinary(String val) {
        if (val == null) {
            return new byte[0];
        }
        if (this.isSourceFile()) {
            try {
                return val.getBytes(ENCODE);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return BinaryUtils.decodeBase64(val);
    }

    @Override
    public AssemblyFileCollection getParent() {
        return (AssemblyFileCollection)super.getParent();
    }
}

