/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UnOrdered;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ColumnCollection
extends AbstractSchemaObjectCollection<Column>
implements UnOrdered,
HasParent<Table>,
NewElement<Column, ColumnCollection> {
    private static final long serialVersionUID = 4500961268819976110L;

    protected ColumnCollection() {
    }

    protected ColumnCollection(Table table) {
        super(table);
    }

    @Override
    protected Supplier<ColumnCollection> newInstance() {
        return () -> new ColumnCollection();
    }

    @Override
    public ColumnCollection clone() {
        return (ColumnCollection)super.clone();
    }

    public ColumnCollection add(String name) {
        Column column = new Column(name);
        this.add(column);
        return this;
    }

    public ColumnCollection add(String name, Consumer<Column> cons) {
        Column obj = new Column(name);
        this.add(obj);
        cons.accept(obj);
        return this;
    }

    @Override
    protected boolean beforeAdd(Column column) {
        if (this.getParent() != null) {
            column.setTableName(null);
            this.getParent().getRows().addColumn(column);
        }
        return true;
    }

    @Override
    protected boolean beforeRemove(Column column) {
        if (this.getParent() != null) {
            this.getParent().getRows().compactionColumn(column);
        }
        return true;
    }

    @Override
    protected void initializeSchemaInfo(Column column) {
        if (this.getParent() == null) {
            super.initializeSchemaInfo(column);
            return;
        }
        if (this.equalsIgnoreCase(column.getCatalogName(), this.getParent().getCatalogName())) {
            column.setCatalogName(null);
        } else {
            column.setCatalogName(this.getParent().getCatalogName());
        }
        if (this.equalsIgnoreCase(column.schemaName, this.getParent().getSchemaName())) {
            column.setSchemaName(null);
        } else {
            column.setCatalogName(this.getParent().getSchemaName());
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ColumnCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    public Column[] toArray() {
        return (Column[])this.toArray(new Column[0]);
    }

    @Override
    public void sort() {
    }

    @Override
    public Table getParent() {
        return (Table)super.getParent();
    }

    @Override
    protected void afterAdd(Column column) {
        column.validate();
    }

    @Override
    public Column find(Column obj) {
        Column column = (Column)this.get(obj.getName());
        if (column != null) {
            return column;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            column = (Column)this.get(i);
            if (column.getOrdinal() != obj.getOrdinal() || !column.like(obj)) continue;
            if (obj.getParent() == null) {
                return column;
            }
            Column eqNameColumn = (Column)obj.getParent().get(column.getName());
            if (eqNameColumn != null) continue;
            return column;
        }
        return null;
    }

    @Override
    protected Supplier<Column> getElementSupplier() {
        return () -> new Column();
    }

    @Override
    public Column newElement() {
        return (Column)super.newElementInternal();
    }
}

