/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.DbInfoEntry;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.AbstractCollectionHandler;
import com.sqlapp.util.xml.EmptyTextSkipHandler;
import com.sqlapp.util.xml.EntryHandler;
import com.sqlapp.util.xml.StaxElementHandler;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

class DbInfoEntryXmlReaderHandler
extends AbstractCollectionHandler<DbInfoEntry> {
    @Override
    public String getLocalName() {
        return "product";
    }

    protected DbInfoEntryXmlReaderHandler() {
        this.registerChild(new EntryHandler());
        this.registerChild(new EmptyTextSkipHandler());
    }

    @Override
    protected void doHandle(StaxReader reader, Object parentObject) throws XMLStreamException {
        DbInfoEntry val = this.createNewInstance();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                Map<String, String> map = this.getAttributeMap(reader);
                val.setProductName(map.get(SchemaProperties.NAME.getLabel()));
                reader.next();
            }
            if (this.match(reader) && reader.isEndElement()) {
                reader.next();
                break;
            }
            this.callChilds(reader, val);
        }
        this.callParent(reader, this.getLocalName(), parentObject, val);
    }

    @Override
    public void doCallback(StaxReader reader, StaxElementHandler child, String name, Object ownObject, Object childObject) throws XMLStreamException {
        DbInfoEntry dbInfoEntry = (DbInfoEntry)CommonUtils.cast(ownObject);
        if (childObject != null) {
            Map.Entry entry = (Map.Entry)CommonUtils.cast(childObject);
            dbInfoEntry.getKeyValues().put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    protected DbInfoEntry createNewInstance() {
        return new DbInfoEntry();
    }
}

