/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractDifference;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DbObjectPropertyDifference;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.PartitionParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.properties.NameGetter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.ToStringBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DbObjectDifference
extends AbstractDifference<DbObject<?>> {
    private static final long serialVersionUID = 6634332562149007807L;
    private Map<String, Difference<?>> properties = CommonUtils.caseInsensitiveTreeMap();
    private static Map<String, Integer> ORDER_MAP = CommonUtils.map();
    private static int ORDER_LEVEL = 0xCCCCCCC;

    protected DbObjectDifference(DbObject<?> original, DbObject<?> target) {
        this(original, target, new EqualsHandler());
    }

    protected DbObjectDifference(String propertyName, DbObject<?> original, DbObject<?> target, EqualsHandler equalsHandler) {
        this(propertyName, original, target, equalsHandler, false);
    }

    protected DbObjectDifference(String propertyName, DbObject<?> original, DbObject<?> target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(propertyName, original, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectDifference(DbObject<?> original, DbObject<?> target, EqualsHandler equalsHandler) {
        this(null, original, target, equalsHandler, false);
    }

    protected DbObjectDifference(DbCommonObject<?> originalParent, DbObject<?> original, DbCommonObject<?> targetParent, DbObject<?> target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(null, originalParent, original, targetParent, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectDifference(String propertyName, DbCommonObject<?> originalParent, DbObject<?> original, DbCommonObject<?> targetParent, DbObject<?> target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(propertyName, originalParent, original, targetParent, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    public DbObjectDifference reverse() {
        DbObjectDifference reverse = new DbObjectDifference(this.getPropertyName(), this.getTargetParent(), (DbObject)this.getTarget(), this.getOriginalParent(), (DbObject)this.getOriginal(), this.getEqualsHandler(), false);
        return reverse;
    }

    @Override
    protected void diff() {
        if (!DbObjectDifference.isDbObject(this.getOriginal(), this.getTarget())) {
            return;
        }
        if (this.getOriginal() == null || this.getTarget() == null) {
            this.setState(State.getState(this.getOriginal(), this.getTarget()));
        } else {
            ((DbCommonObject)this.getOriginal()).equals(this.getTarget(), new DifferenceEqualsHandler(this, this.getEqualsHandler()));
            for (Map.Entry<String, Difference<?>> entry : this.getProperties().entrySet()) {
                if (!entry.getValue().getState().isChanged()) continue;
                this.setState(State.Modified);
                break;
            }
        }
    }

    public Map<String, Difference<?>> getProperties() {
        return this.properties;
    }

    public Map<String, Difference<?>> getProperties(State ... states) {
        Set<State[]> set = CommonUtils.set(states);
        return this.getPropertiesInternal(state -> set.contains(state));
    }

    public Map<String, Difference<?>> getChangedProperties() {
        return this.getPropertiesInternal(state -> state.isChanged());
    }

    private Map<String, Difference<?>> getPropertiesInternal(Predicate<State> p) {
        Map<String, Difference<?>> result = CommonUtils.caseInsensitiveTreeMap();
        for (Map.Entry<String, Difference<?>> entry : this.properties.entrySet()) {
            if (!p.test(entry.getValue().getState())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, Difference<?>> getProperties(Dialect dialect, State ... states) {
        Set<State[]> set = CommonUtils.set(states);
        return this.getPropertiesInternal(dialect, state -> set.contains(state));
    }

    public Map<String, Difference<?>> getChangedProperties(Dialect dialect) {
        return this.getPropertiesInternal(dialect, state -> state.isChanged());
    }

    private Map<String, Difference<?>> getPropertiesInternal(Dialect dialect, Predicate<State> p) {
        Map<String, Difference<?>> result = CommonUtils.caseInsensitiveTreeMap();
        for (Map.Entry<String, Difference<?>> entry : this.properties.entrySet()) {
            if (!entry.getValue().getState().isChanged()) continue;
            if (entry.getValue() instanceof DbObjectPropertyDifference) {
                if (SchemaProperties.SPECIFICS.getLabel().equals(entry.getKey()) || SchemaProperties.STATISTICS.getLabel().equals(entry.getKey())) {
                    List<DbObjectPropertyDifference> props = ((DbObjectPropertyDifference)entry.getValue()).toList();
                    for (DbObjectPropertyDifference prop : props) {
                        if (!p.test(prop.getState())) continue;
                        result.put(prop.getPropertyName(), prop);
                    }
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public List<DbObjectPropertyDifference> findModifiedProperties(Dialect dialect, String propertyName, Class<? extends DbObject<?>> clazz) {
        List<DbObjectPropertyDifference> result = CommonUtils.list();
        if (this.isTargetClass(this.getOriginal(), clazz) || this.isTargetClass(this.getTarget(), clazz)) {
            Map<String, Difference<?>> differeces = this.getProperties();
            for (Map.Entry<String, Difference<?>> entry : differeces.entrySet()) {
                if (!(entry.getValue() instanceof DbObjectPropertyDifference)) continue;
                if (SchemaProperties.SPECIFICS.getLabel().equals(entry.getKey()) || SchemaProperties.STATISTICS.getLabel().equals(entry.getKey())) {
                    List<DbObjectPropertyDifference> props = ((DbObjectPropertyDifference)entry.getValue()).toList();
                    for (DbObjectPropertyDifference prop : props) {
                        if (!propertyName.equals(prop.getPropertyName()) || !prop.getState().isChanged()) continue;
                        result.add(prop);
                    }
                    continue;
                }
                if (!propertyName.equals(entry.getKey()) || !entry.getValue().getState().isChanged()) continue;
                result.add((DbObjectPropertyDifference)entry.getValue());
            }
        } else {
            Map<String, Difference<?>> differeces = this.getProperties();
            for (Map.Entry<String, Difference<?>> entry : differeces.entrySet()) {
                if (entry.getValue() instanceof DbObjectDifferenceCollection) {
                    DbObjectDifferenceCollection diffCollection = (DbObjectDifferenceCollection)entry.getValue();
                    List<DbObjectPropertyDifference> childResult = diffCollection.findModifiedProperties(dialect, propertyName, clazz);
                    result.addAll(childResult);
                    continue;
                }
                if (!(entry.getValue() instanceof DbObjectDifference)) continue;
                DbObjectDifference diff = (DbObjectDifference)entry.getValue();
                result.addAll(diff.findModifiedProperties(dialect, propertyName, clazz));
            }
        }
        return result;
    }

    private boolean isTargetClass(Object obj, Class<? extends DbObject<?>> clazz) {
        if (obj == null) {
            return false;
        }
        return clazz.isAssignableFrom(obj.getClass());
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        if (this.getState() == State.Deleted) {
            builder.add(this.format(this.getState(), this.getOriginal()));
        } else if (this.getState() == State.Added) {
            builder.add(this.format(this.getState(), this.getTarget()));
        } else if (this.getState() == State.Modified) {
            this.toStringDetail(builder);
        }
    }

    protected void toStringDetail(ToStringBuilder builder) {
        SeparatedStringBuilder sepBuilder = new SeparatedStringBuilder(", ");
        Map<String, Difference<?>> props = this.getChangedProperties();
        sepBuilder.setStart(this.getStateText(this.getState()) + ":" + this.getSimpleName(this.getOriginal()));
        Difference<?> nameDiff = null;
        if (this.getOriginal() instanceof NameGetter) {
            nameDiff = this.getProperties().get(SchemaProperties.NAME.getLabel());
        } else if (this.getOriginal() instanceof PartitionParent) {
            nameDiff = this.getProperties().get(SchemaProperties.TABLE_NAME.getLabel());
        }
        SeparatedStringBuilder sepChildBuilder = new SeparatedStringBuilder(", ");
        sepChildBuilder.setStart("[").setEnd("]");
        if (!props.containsKey(SchemaProperties.NAME.getLabel()) && nameDiff != null) {
            if (nameDiff.getState().isChanged()) {
                sepChildBuilder.add((Object)nameDiff);
            } else if (nameDiff.getOriginal() != null) {
                sepChildBuilder.add((Object)("name=" + nameDiff.getOriginal()));
            }
        }
        int indentSize = this.getLevel();
        List<Map.Entry<String, Difference<?>>> list = this.sort(props);
        for (Map.Entry<String, Difference<?>> entry : list) {
            Difference<?> value = entry.getValue();
            sepChildBuilder.add((Object)value);
        }
        if (props.size() > 0) {
            String val = sepChildBuilder.toString();
            sepBuilder.add((Object)val);
        }
        String indent = CommonUtils.getString('\t', indentSize);
        builder.add("\n" + indent + sepBuilder.toString());
    }

    private List<Map.Entry<String, Difference<?>>> sort(Map<String, Difference<?>> map) {
        List<Map.Entry<String, Difference<?>>> list = map.entrySet().stream().collect(Collectors.toList());
        Collections.sort(list, new Comparator<Map.Entry<String, Difference<?>>>(){

            @Override
            public int compare(Map.Entry<String, Difference<?>> o1, Map.Entry<String, Difference<?>> o2) {
                Integer val1 = ORDER_MAP.get(o1.getKey());
                Integer val2 = ORDER_MAP.get(o2.getKey());
                if (val1 == null) {
                    if (val2 == null) {
                        return 0;
                    }
                    if (val2 > ORDER_LEVEL) {
                        return -1;
                    }
                    return 1;
                }
                if (val2 == null) {
                    if (val1 > ORDER_LEVEL) {
                        return 1;
                    }
                    return -1;
                }
                return val1.compareTo(val2);
            }
        });
        return list;
    }

    @Override
    public int compareTo(Difference<?> o) {
        if (o instanceof DbObjectPropertyDifference) {
            return 1;
        }
        if (o instanceof DbObjectDifferenceCollection) {
            return -1;
        }
        return 0;
    }

    @Override
    public void removeRecursive(BiPredicate<String, Difference<?>> predicate) {
        Set<String> set = CommonUtils.set();
        for (String key : this.properties.keySet()) {
            Difference<?> difference = this.properties.get(key);
            difference.removeRecursive(predicate);
            if (!predicate.test(key, difference)) continue;
            set.add(key);
        }
        for (String key : set) {
            this.properties.remove(key);
        }
        if (this.properties.isEmpty()) {
            this.setState(State.Unchanged);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DbObjectDifference)) {
            return false;
        }
        DbObjectDifference cst = (DbObjectDifference)obj;
        return this.getProperties().equals(cst.getProperties());
    }

    static {
        int i = 0;
        ORDER_MAP.put(SchemaProperties.CATALOG_NAME.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.SCHEMA_NAME.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.SPECIFIC_NAME.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.DISPLAY_NAME.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.NAME.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.ORDINAL.getLabel(), i++);
        i = ORDER_LEVEL;
        ORDER_MAP.put(SchemaProperties.CREATED_AT.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.LAST_ALTERED_AT.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.DISPLAY_REMARKS.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.REMARKS.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.STATISTICS.getLabel(), i++);
        ORDER_MAP.put(SchemaProperties.SPECIFICS.getLabel(), i++);
    }

    protected static class DifferenceEqualsHandler
    extends EqualsHandler {
        private DbObjectDifference dbObjectDifference = null;
        private final EqualsHandler equalsHandler;

        protected DifferenceEqualsHandler(DbObjectDifference dbObjectDifference, EqualsHandler equalsHandler) {
            this.dbObjectDifference = dbObjectDifference;
            this.equalsHandler = equalsHandler;
        }

        @Override
        protected boolean referenceEquals(Object object1, Object object2) {
            return this.equalsHandler.referenceEquals(object1, object2);
        }

        @Override
        protected boolean valueEquals(String propertyName, Object object1, Object object2, Object value1, Object value2, BooleanSupplier p) {
            boolean result = this.equalsHandler.valueEquals(propertyName, object1, object2, value1, value2, p);
            return this.equalsInternal(propertyName, result, object1, object2, value1, value2);
        }

        protected boolean equalsInternal(String propertyName, boolean result, Object object1, Object object2, Object value1, Object value2) {
            if (AbstractDifference.isDbObjectCollection(value1, value2)) {
                DbObjectDifferenceCollection diff = new DbObjectDifferenceCollection(propertyName, (DbObjectCollection)value1, (DbObjectCollection)value2, this.equalsHandler, result);
                diff.setParentDifference(this.dbObjectDifference);
                this.dbObjectDifference.getProperties().put(propertyName, diff);
            } else if (AbstractDifference.isDbObject(value1, value2)) {
                DbObjectDifference diff = new DbObjectDifference(propertyName, (DbCommonObject)object1, (DbObject)value1, (DbCommonObject)object2, (DbObject)value2, this.equalsHandler, result);
                diff.setParentDifference(this.dbObjectDifference);
                this.dbObjectDifference.getProperties().put(propertyName, diff);
            } else {
                DbObjectPropertyDifference diff = new DbObjectPropertyDifference(propertyName, (DbCommonObject)object1, value1, (DbCommonObject)object2, value2, this.equalsHandler, result);
                diff.setParentDifference(this.dbObjectDifference);
                if (result) {
                    diff.setState(State.Unchanged);
                } else {
                    diff.setState(State.Modified);
                }
                this.dbObjectDifference.getProperties().put(propertyName, diff);
            }
            return true;
        }

        @Override
        protected boolean equalsResult(Object object1, Object object2) {
            return this.equalsHandler.equalsResult(object1, object2);
        }

        @Override
        public DifferenceEqualsHandler clone() {
            return (DifferenceEqualsHandler)super.clone();
        }
    }
}

