/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Directory;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExternalTableCollection;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.properties.AccessParametersProperty;
import com.sqlapp.data.schemas.properties.AccessTypeProperty;
import com.sqlapp.data.schemas.properties.DefaultDirectoryNameProperty;
import com.sqlapp.data.schemas.properties.DirectoryNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LocationProperty;
import com.sqlapp.data.schemas.properties.PropertyProperty;
import com.sqlapp.data.schemas.properties.RejectLimitProperty;
import com.sqlapp.data.schemas.properties.TypeNameProperty;
import com.sqlapp.data.schemas.properties.TypeSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class ExternalTable
extends AbstractSchemaObject<ExternalTable>
implements HasParent<ExternalTableCollection>,
TypeSchemaNameProperty<ExternalTable>,
TypeNameProperty<ExternalTable>,
DefaultDirectoryNameProperty<ExternalTable>,
DirectoryNameProperty<ExternalTable>,
LocationProperty<ExternalTable>,
RejectLimitProperty<ExternalTable>,
AccessTypeProperty<ExternalTable>,
AccessParametersProperty<ExternalTable>,
PropertyProperty<ExternalTable> {
    private static final long serialVersionUID = 1L;
    private Type type = null;
    private Directory defaultDirectory = null;
    private Directory directory = null;
    private String location = null;
    private String rejectLimit = null;
    private String accessType = null;
    private String accessParameters = null;
    private String property = null;

    public ExternalTable() {
    }

    public ExternalTable(String name) {
        super(name);
    }

    @Override
    protected Supplier<ExternalTable> newInstance() {
        return () -> new ExternalTable();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof ExternalTable)) {
            return false;
        }
        ExternalTable val = (ExternalTable)obj;
        if (!this.equals(SchemaProperties.TYPE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TYPE_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT_DIRECTORY_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DIRECTORY_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOCATION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.REJECT_LIMIT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACCESS_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACCESS_PARAMETERS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PROPERTY, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.TYPE_NAME, this.getTypeName());
        builder.add((ISchemaProperty)SchemaProperties.DEFAULT_DIRECTORY_NAME, this.getDefaultDirectoryName());
        builder.add((ISchemaProperty)SchemaProperties.DIRECTORY_NAME, this.getDirectoryName());
        builder.add((ISchemaProperty)SchemaProperties.LOCATION, this.getLocation());
        builder.add((ISchemaProperty)SchemaProperties.REJECT_LIMIT, this.getRejectLimit());
        builder.add((ISchemaProperty)SchemaProperties.ACCESS_TYPE, this.getAccessType());
        builder.add((ISchemaProperty)SchemaProperties.ACCESS_PARAMETERS, this.getAccessParameters());
        builder.add((ISchemaProperty)SchemaProperties.PROPERTY, this.getProperty());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.TYPE_SCHEMA_NAME.getLabel(), this.getTypeSchemaName());
        stax.writeAttribute(SchemaProperties.TYPE_NAME.getLabel(), this.getTypeName());
        stax.writeAttribute(SchemaProperties.DEFAULT_DIRECTORY_NAME.getLabel(), this.getDefaultDirectoryName());
        stax.writeAttribute(SchemaProperties.DIRECTORY_NAME.getLabel(), this.getDirectoryName());
        stax.writeAttribute(SchemaProperties.LOCATION.getLabel(), this.getLocation());
        stax.writeAttribute(SchemaProperties.REJECT_LIMIT.getLabel(), this.getRejectLimit());
        stax.writeAttribute(SchemaProperties.ACCESS_TYPE.getLabel(), this.getAccessType());
        stax.writeAttribute(SchemaProperties.PROPERTY.getLabel(), this.getProperty());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getAccessParameters())) {
            stax.newLine();
            stax.writeCData(SchemaProperties.ACCESS_PARAMETERS.getLabel(), this.getAccessParameters());
        }
    }

    @Override
    public ExternalTableCollection getParent() {
        return (ExternalTableCollection)super.getParent();
    }

    public Type getType() {
        if (this.type != null && this.type.getParent() == null) {
            this.type = this.getTypeFromParent(this.type);
        }
        return this.type;
    }

    @Override
    public String getTypeSchemaName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getSchemaName();
    }

    public ExternalTable setType(Type type) {
        this.type = type != null && type.getParent() == null ? this.getTypeFromParent(type) : type;
        return this;
    }

    @Override
    public String getTypeName() {
        if (this.getType() == null) {
            return null;
        }
        return this.getType().getName();
    }

    @Override
    public ExternalTable setTypeSchemaName(String typeSchemaName) {
        if (this.getType() == null) {
            this.type = new Type();
        }
        this.getType().setSchemaName(typeSchemaName);
        return (ExternalTable)this.instance();
    }

    @Override
    public ExternalTable setTypeName(String typeName) {
        if (CommonUtils.isEmpty(typeName)) {
            this.type = null;
        } else if (this.getType() != null) {
            if (!CommonUtils.eq(this.getType().getName(), typeName)) {
                this.setType(new Type(typeName));
            }
        } else {
            this.setType(new Type(typeName));
        }
        return this;
    }

    protected Type getTypeFromParent(Type type) {
        if (this.getParent() == null) {
            return type;
        }
        if (this.getParent().getSchema() == null) {
            return type;
        }
        if (CommonUtils.eq(this.getTypeSchemaName(), type.getSchemaName())) {
            Type getType = (Type)this.getParent().getSchema().getTypes().get(type.getName());
            if (getType != null) {
                return getType;
            }
        } else {
            if (this.getParent().getSchema().getParent() == null) {
                return type;
            }
            Schema schema = (Schema)this.getParent().getSchema().getParent().get(type.getSchemaName());
            if (schema == null) {
                return type;
            }
            Type getType = (Type)schema.getTypes().get(type.getName());
            if (getType != null) {
                return getType;
            }
        }
        return type;
    }

    public Directory getDefaultDirectory() {
        if (this.defaultDirectory != null && this.defaultDirectory.getParent() == null) {
            this.defaultDirectory = this.getDirectoryFromParent(this.defaultDirectory);
        }
        return this.defaultDirectory;
    }

    protected Directory getDirectoryFromParent(Directory directory) {
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return directory;
        }
        Directory getDirectory = (Directory)catalog.getDirectories().get(directory.getName());
        if (getDirectory != null) {
            return getDirectory;
        }
        return directory;
    }

    @Override
    public String getDefaultDirectoryName() {
        if (this.defaultDirectory == null) {
            return null;
        }
        return this.getDefaultDirectory().getName();
    }

    public ExternalTable setDefaultDirectory(Directory defaultDirectory) {
        this.defaultDirectory = defaultDirectory != null && defaultDirectory.getParent() == null ? this.getDirectoryFromParent(defaultDirectory) : defaultDirectory;
        return this;
    }

    @Override
    public ExternalTable setDefaultDirectoryName(String defaultDirectoryName) {
        if (CommonUtils.isEmpty(defaultDirectoryName)) {
            this.defaultDirectory = null;
        } else {
            this.setDefaultDirectory(new Directory(defaultDirectoryName));
        }
        return this;
    }

    public Directory getDirectory() {
        if (this.directory == null) {
            return this.getDefaultDirectory();
        }
        if (this.directory.getParent() == null) {
            this.directory = this.getDirectoryFromParent(this.directory);
        }
        return this.directory;
    }

    @Override
    public String getDirectoryName() {
        if (this.getDirectory() == null) {
            return null;
        }
        return this.getDirectory().getName();
    }

    public ExternalTable setDirectory(Directory directory) {
        this.directory = directory != null && directory.getParent() == null ? this.getDirectoryFromParent(directory) : directory;
        return this;
    }

    @Override
    public ExternalTable setDirectoryName(String directory) {
        if (CommonUtils.isEmpty(directory)) {
            this.directory = null;
        } else {
            this.setDirectory(new Directory(directory));
        }
        return this;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public ExternalTable setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public String getRejectLimit() {
        return this.rejectLimit;
    }

    @Override
    public ExternalTable setRejectLimit(String rejectLimit) {
        this.rejectLimit = rejectLimit;
        return this;
    }

    @Override
    public String getAccessType() {
        return this.accessType;
    }

    @Override
    public ExternalTable setAccessType(String accessType) {
        this.accessType = accessType;
        return this;
    }

    @Override
    public String getAccessParameters() {
        return this.accessParameters;
    }

    @Override
    public ExternalTable setAccessParameters(String accessParameters) {
        this.accessParameters = accessParameters;
        return (ExternalTable)this.instance();
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public ExternalTable setProperty(String property) {
        this.property = property;
        return (ExternalTable)this.instance();
    }
}

