/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractColumnConstraint;
import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ForeignKeyConstraintXmlReaderHandler;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DeleteRuleProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.MatchOptionProperty;
import com.sqlapp.data.schemas.properties.RelatedTableNameProperty;
import com.sqlapp.data.schemas.properties.RelatedTableSchemaNameProperty;
import com.sqlapp.data.schemas.properties.UpdateRuleProperty;
import com.sqlapp.data.schemas.properties.object.RelatedColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public final class ForeignKeyConstraint
extends AbstractColumnConstraint<ForeignKeyConstraint>
implements UpdateRuleProperty<ForeignKeyConstraint>,
DeleteRuleProperty<ForeignKeyConstraint>,
RelatedTableSchemaNameProperty<ForeignKeyConstraint>,
RelatedTableNameProperty<ForeignKeyConstraint>,
RelatedColumnsProperty<ForeignKeyConstraint>,
MatchOptionProperty<ForeignKeyConstraint> {
    private static final long serialVersionUID = -2991007538747094902L;
    private String relatedTableSchemaName = null;
    private String relatedTableName = null;
    private ReferenceColumnCollection relatedColumns = new ReferenceColumnCollection(this);
    protected static final String RELATED_TABLE = "relatedTable";
    private CascadeRule updateRule = null;
    private CascadeRule deleteRule = null;
    private MatchOption matchOption = null;

    public ForeignKeyConstraint() {
    }

    public ForeignKeyConstraint(String name) {
        super(name, new Column[0]);
    }

    @Override
    protected Supplier<Constraint> newInstance() {
        return () -> new ForeignKeyConstraint();
    }

    public ForeignKeyConstraint(String constraintName, Column[] columns, Column[] relatedColumns) {
        super(constraintName, columns);
        this.setRelatedColumns(relatedColumns);
    }

    public ForeignKeyConstraint(String constraintName, Column column, Column relatedColumn) {
        super(constraintName, column);
        this.setRelatedColumns(relatedColumn);
    }

    public ForeignKeyConstraint(String constraintName, List<Column> relatedColumns, List<Column> columns) {
        super(constraintName, columns);
        this.setRelatedColumns(relatedColumns.toArray(new Column[0]));
    }

    public Table getRelatedTable() {
        if (this.relatedColumns == null) {
            return null;
        }
        Table table = SchemaUtils.getTableOnlyFromParent(this.getRelatedTableSchemaName(), this.getRelatedTableName(), this);
        if (table == null) {
            table = this.relatedColumns.getTable();
        }
        return table;
    }

    @Override
    protected void validate() {
        Table relatedTable;
        super.validate();
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.setRelation(this.getTable(), this.getColumns());
        }
        if (!CommonUtils.isEmpty(this.relatedColumns) && (relatedTable = this.getRelatedTable()) != null) {
            if (relatedTable.getChildRelations() == null) {
                relatedTable.setChildRelations(CommonUtils.list());
            }
            relatedTable.addChildRelation(this);
        }
    }

    protected void setRelation(Table table, Column ... columns) {
        if (table == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            Column getColumn = (Column)table.getColumns().get(columns[i].getName());
            if (getColumn == null) continue;
            columns[i] = getColumn;
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ForeignKeyConstraint)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        ForeignKeyConstraint val = (ForeignKeyConstraint)obj;
        if (!this.equals(SchemaProperties.RELATED_TABLE_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.RELATED_TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.RELATED_COLUMNS, val, equalsHandler, EqualsUtils.getEqualsSupplier(this.eqColumnName(this.getRelatedColumns(), val.getRelatedColumns())))) {
            return false;
        }
        if (!this.equals(SchemaProperties.UPDATE_RULE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DELETE_RULE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MATCH_OPTION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.VIRTUAL, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        if (this.getColumns() != null && this.getColumns().length > 0) {
            builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        }
        super.toStringDetail(builder);
        if (this.getRelatedColumns() != null && !this.getRelatedColumns().isEmpty()) {
            String schemaName = this.getRelatedTableSchemaName();
            if (!CommonUtils.eqIgnoreCase(schemaName, ForeignKeyConstraint.getSchemaName(this.getColumns()))) {
                builder.add((ISchemaProperty)SchemaProperties.RELATED_TABLE_SCHEMA_NAME, this.getRelatedTableSchemaName());
            }
            builder.add((ISchemaProperty)SchemaProperties.RELATED_TABLE_NAME, this.getRelatedTableName());
            builder.add((ISchemaProperty)SchemaObjectProperties.RELATED_COLUMNS, this.getRelatedColumnsString());
        }
        builder.add((ISchemaProperty)SchemaProperties.UPDATE_RULE, (Object)this.getUpdateRule());
        builder.add((ISchemaProperty)SchemaProperties.DELETE_RULE, (Object)this.getDeleteRule());
        builder.add((ISchemaProperty)SchemaProperties.MATCH_OPTION, (Object)this.getMatchOption());
        builder.add(SchemaProperties.VIRTUAL.getLabel(), this.isVirtual());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.UPDATE_RULE.getLabel(), (Object)this.getUpdateRule());
        stax.writeAttribute(SchemaProperties.DELETE_RULE.getLabel(), (Object)this.getDeleteRule());
        if (this.matchOption != MatchOption.Simple) {
            stax.writeAttribute(SchemaProperties.MATCH_OPTION.getLabel(), (Object)this.getMatchOption());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        this.writeTable(stax);
        this.writeRelatedTable(stax);
    }

    private void writeTable(StaxWriter stax) throws XMLStreamException {
        Table table = this.getTable();
        if (this.getParent() == null || this.getParent().getTable() == table) {
            return;
        }
        stax.newLine();
        stax.indent();
        stax.writeStartElement("table");
        if (this.getParent() != null && this.getParent().getTable() != table) {
            stax.writeAttribute(SchemaProperties.NAME.getLabel(), table.getName());
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), table.getSchemaName());
        }
        stax.addIndentLevel(1);
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    private void writeRelatedTable(StaxWriter stax) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeStartElement(RELATED_TABLE);
        stax.writeAttribute(SchemaProperties.NAME.getLabel(), this.getRelatedTableName());
        if (!CommonUtils.eq(this.getTable().getSchemaName(), this.getRelatedTableSchemaName())) {
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getRelatedTableSchemaName());
        }
        stax.addIndentLevel(1);
        this.writeColumns(SchemaObjectProperties.COLUMNS.getLabel(), stax, this.getRelatedColumns());
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    @Override
    public CascadeRule getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public ForeignKeyConstraint setUpdateRule(CascadeRule updateRule) {
        this.updateRule = updateRule;
        return this;
    }

    @Override
    public CascadeRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public ForeignKeyConstraint setDeleteRule(CascadeRule deleteRule) {
        this.deleteRule = deleteRule;
        return this;
    }

    @Override
    public ReferenceColumnCollection getRelatedColumns() {
        return this.relatedColumns;
    }

    @Override
    public ForeignKeyConstraint setRelatedColumns(Column ... relatedColumns) {
        if (this.relatedColumns == null) {
            this.relatedColumns = new ReferenceColumnCollection(this);
        } else {
            this.relatedColumns.clear();
        }
        for (Column column : relatedColumns) {
            if (column.getTableName() != null) {
                this.setRelatedTableName(column.getTableName());
            }
            this.relatedColumns.add(column);
        }
        return this;
    }

    public ForeignKeyConstraint addRelatedColumn(Column relatedColumn) {
        if (this.relatedColumns == null) {
            this.relatedColumns = new ReferenceColumnCollection(this);
        }
        if (relatedColumn.getTableName() != null) {
            this.setRelatedTableName(relatedColumn.getTableName());
        }
        this.relatedColumns.add(relatedColumn);
        return this;
    }

    public ForeignKeyConstraint addRelatedColumns(List<Column> relatedColumns) {
        for (Column column : relatedColumns) {
            this.addRelatedColumn(column);
        }
        return this;
    }

    @Override
    public MatchOption getMatchOption() {
        return this.matchOption;
    }

    @Override
    public ForeignKeyConstraint setMatchOption(MatchOption matchOption) {
        this.matchOption = matchOption;
        return this;
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<Constraint> getDbObjectXmlReaderHandler() {
        return new ForeignKeyConstraintXmlReaderHandler();
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof ForeignKeyConstraint)) {
            return false;
        }
        ForeignKeyConstraint con = (ForeignKeyConstraint)obj;
        if (!CommonUtils.eq(this.getName(), con.getName()) && this.getParent() != null && con.getParent() != null && (this.getParent().contains(con.getName()) || con.getParent().contains(this.getName()))) {
            return false;
        }
        if (!CommonUtils.eq(this.getColumnsString(), con.getColumnsString())) {
            return false;
        }
        return CommonUtils.eq(this.getRelatedColumnsString(), con.getRelatedColumnsString());
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add((ISchemaProperty)SchemaProperties.CATALOG_NAME, this.getCatalogName());
            builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
        }
        builder.add((ISchemaProperty)SchemaProperties.NAME, this.getName());
        builder.add((ISchemaProperty)SchemaObjectProperties.COLUMNS, this.getColumnsString());
        if (this.getRelatedTable() != null) {
            builder.add((ISchemaProperty)SchemaProperties.RELATED_TABLE_NAME, this.getRelatedTableName());
        }
        builder.add((ISchemaProperty)SchemaObjectProperties.RELATED_COLUMNS, this.getRelatedColumnsString());
        return builder.toString();
    }

    private String getColumnsString() {
        SeparatedStringBuilder sep = new SeparatedStringBuilder(", ");
        sep.setStart("(").setEnd(")");
        for (Column column : this.getColumns()) {
            sep.add((Object)column.getName());
        }
        return sep.toString();
    }

    private String getRelatedColumnsString() {
        SeparatedStringBuilder sep = new SeparatedStringBuilder(", ");
        sep.setStart("(").setEnd(")");
        for (ReferenceColumn column : this.getRelatedColumns()) {
            sep.add((Object)column.getName());
        }
        return sep.toString();
    }

    @Override
    protected ForeignKeyConstraint instance() {
        return this;
    }

    @Override
    public ForeignKeyConstraint setEnable(boolean bool) {
        super.setEnable(bool);
        return this.instance();
    }

    @Override
    public ForeignKeyConstraint setDeferrability(Deferrability deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }

    @Override
    public ForeignKeyConstraint setDeferrability(String deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }

    @Override
    public String getRelatedTableName() {
        return this.relatedTableName;
    }

    @Override
    public ForeignKeyConstraint setRelatedTableName(String value) {
        this.relatedTableName = value;
        return this.instance();
    }

    @Override
    public String getRelatedTableSchemaName() {
        String name;
        if (!CommonUtils.isEmpty(this.relatedColumns) && (name = this.relatedColumns.getSchemaName()) != null) {
            return name;
        }
        if (this.relatedTableSchemaName == null) {
            return this.getSchemaName();
        }
        return this.relatedTableSchemaName;
    }

    @Override
    public ForeignKeyConstraint setRelatedTableSchemaName(String value) {
        this.relatedTableSchemaName = value;
        return this.instance();
    }

    public static enum MatchOption implements EnumProperties
    {
        Full("FULL", "f.*"),
        Partial("PARTIAL", "p.*"),
        Simple("SIMPLE", "(s.*|default)");

        private final String text;
        private final Pattern pattern;

        private MatchOption(String text, String patternText) {
            this.text = text;
            this.pattern = Pattern.compile(patternText, 2);
        }

        public static MatchOption parse(String text) {
            if (text == null) {
                return null;
            }
            for (MatchOption e : MatchOption.values()) {
                Matcher matcher = e.pattern.matcher(text);
                if (!matcher.matches()) continue;
                return e;
            }
            return null;
        }

        @Override
        public String getDisplayName() {
            return this.text;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.getDisplayName();
        }

        @Override
        public String getSqlValue() {
            return this.getDisplayName();
        }
    }
}

