/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;

class GetAllDbObjectEqualsHandler
extends EqualsHandler {
    private Predicate<DbObject<?>> predicate;
    private Consumer<DbObject<?>> consumer;

    GetAllDbObjectEqualsHandler(Consumer<DbObject<?>> consumer) {
        this.consumer = consumer;
        this.predicate = c -> true;
    }

    GetAllDbObjectEqualsHandler(Consumer<DbObject<?>> consumer, Predicate<DbObject<?>> predicate) {
        this.consumer = consumer;
        this.predicate = predicate;
    }

    @Override
    protected boolean referenceEquals(Object object1, Object object2) {
        DbObject val;
        if (object1 instanceof DbObject && this.predicate.test(val = (DbObject)object1)) {
            this.consumer.accept(val);
        }
        return false;
    }

    @Override
    protected boolean valueEquals(String propertyName, Object object1, Object object2, Object value1, Object value2, BooleanSupplier p) {
        if (value1 instanceof DbObject) {
            DbObject val2 = (DbObject)value1;
            if (this.predicate.test(val2)) {
                this.consumer.accept(val2);
            }
        } else if (value1 instanceof DbObjectCollection) {
            DbObjectCollection c = (DbObjectCollection)value1;
            c.stream().filter(val -> this.predicate.test((DbObject<?>)val)).forEach(val -> val.applyAll(this.consumer));
        }
        return true;
    }

    @Override
    protected boolean equalsResult(Object object1, Object object2) {
        return true;
    }

    @Override
    public GetAllDbObjectEqualsHandler clone() {
        return (GetAllDbObjectEqualsHandler)super.clone();
    }
}

