/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.function.Supplier;

public final class IndexCollection
extends AbstractSchemaObjectCollection<Index>
implements Cloneable,
HasParent<Table>,
NewElement<Index, IndexCollection> {
    private static final long serialVersionUID = 6007580646027193828L;

    protected IndexCollection() {
    }

    protected IndexCollection(Table table) {
        super(table);
    }

    @Override
    protected Supplier<IndexCollection> newInstance() {
        return () -> new IndexCollection();
    }

    @Override
    public IndexCollection clone() {
        return (IndexCollection)super.clone();
    }

    public Index add(String indexName, Column ... columns) {
        return this.add(indexName, false, columns);
    }

    public Index add(String indexName, Collection<Column> columns) {
        return this.add(indexName, false, columns);
    }

    public Index add(String indexName, boolean unique, Column ... columns) {
        Index index = new Index(indexName);
        index.setUnique(unique);
        for (Column column : columns) {
            index.getColumns().add(column);
        }
        this.add(index);
        return index;
    }

    public Index add(String indexName, boolean unique, Collection<Column> columns) {
        return this.add(indexName, unique, columns.toArray(new Column[0]));
    }

    @Override
    protected void afterRemove(Index args) {
        if (this.getParent() != null) {
            this.getParent().getConstraints().remove(args.getName());
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof IndexCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public Table getParent() {
        return (Table)super.getParent();
    }

    @Override
    public Index find(Index obj) {
        for (Index index : this) {
            if (!CommonUtils.eq(index.getTableName(), obj.getTableName())) continue;
            if (CommonUtils.eq(index.getName(), obj.getName())) {
                return index;
            }
            if (!CommonUtils.eq(index.getColumns(), obj.getColumns())) continue;
            return index;
        }
        return null;
    }

    @Override
    public Index newElement() {
        return (Index)super.newElementInternal();
    }

    @Override
    protected Supplier<Index> getElementSupplier() {
        return () -> new Index();
    }
}

