/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NamedArgumentCollection;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DirectionProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.ReadonlyProperty;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class NamedArgument
extends AbstractColumn<NamedArgument>
implements HasParent<NamedArgumentCollection<?>>,
ReadonlyProperty<NamedArgument>,
DirectionProperty<NamedArgument> {
    private static final long serialVersionUID = -3927630688300024633L;
    private Routine<?> routine;
    private ParameterDirection direction = ParameterDirection.Input;
    private Boolean readonly = null;
    private static final String SIMPLE_NAME = SchemaUtils.getSingularName(SchemaObjectProperties.ARGUMENTS.getLabel());

    public NamedArgument() {
    }

    public NamedArgument(String name) {
        super(name);
    }

    @Override
    protected Supplier<NamedArgument> newInstance() {
        return () -> new NamedArgument();
    }

    protected void setRoutine(Routine<?> routine) {
        this.routine = routine;
    }

    public <S extends Routine<?>> S getRoutine() {
        if (this.getParent() != null && ((NamedArgumentCollection)this.getParent()).getParent() != null) {
            return (S)((NamedArgumentCollection)this.getParent()).getParent();
        }
        return (S)this.routine;
    }

    public String getRoutineName() {
        if (this.getRoutine() == null) {
            return null;
        }
        return ((AbstractNamedObject)this.getRoutine()).getName();
    }

    @Override
    public ParameterDirection getDirection() {
        return this.direction;
    }

    @Override
    public NamedArgument setDirection(ParameterDirection direction) {
        this.direction = direction;
        return this;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        builder.add((ISchemaProperty)SchemaProperties.DIRECTION, (Object)this.getDirection());
        builder.add((ISchemaProperty)SchemaProperties.READONLY, (Object)this.getReadonly());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof NamedArgument)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        NamedArgument val = (NamedArgument)obj;
        if (!this.equals(SchemaProperties.DIRECTION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.READONLY, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DIRECTION.getLabel(), (Object)this.getDirection());
        stax.writeAttribute(SchemaProperties.READONLY.getLabel(), (Object)this.getReadonly());
    }

    @Override
    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    @Override
    public NamedArgumentCollection<?> getParent() {
        return (NamedArgumentCollection)super.getParent();
    }

    @Override
    public NamedArgument setName(String name) {
        super.setName(name);
        return (NamedArgument)this.instance();
    }

    @Override
    public Boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public NamedArgument setReadonly(Boolean readOnly) {
        this.readonly = readOnly;
        return this;
    }
}

