/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum NullsOrder implements EnumProperties
{
    NullsFirst("NULLS FIRST", "(nulls)[\\s]*first"),
    NullsLast("NULLS FIRST", "(nulls)[\\s]*last");

    private final String text;
    private final Pattern pattern;

    private NullsOrder(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static NullsOrder parse(String text) {
        if (text == null) {
            return null;
        }
        for (NullsOrder order : NullsOrder.values()) {
            Matcher matcher = order.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return order;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.text;
    }

    @Override
    public String getSqlValue() {
        return this.text;
    }
}

