/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.OperatorArgument;
import com.sqlapp.data.schemas.OperatorBindingCollection;
import com.sqlapp.data.schemas.OperatorCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.HashesProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.MergesProperty;
import com.sqlapp.data.schemas.properties.complex.CommutativeOperatorProperty;
import com.sqlapp.data.schemas.properties.complex.FunctionProperty;
import com.sqlapp.data.schemas.properties.complex.JoinFunctionProperty;
import com.sqlapp.data.schemas.properties.complex.NegationOperatorProperty;
import com.sqlapp.data.schemas.properties.complex.RestrictFunctionProperty;
import com.sqlapp.data.schemas.properties.object.OperatorBindingsProperty;
import com.sqlapp.data.schemas.properties.object.OperatorLeftArgumentProperty;
import com.sqlapp.data.schemas.properties.object.OperatorRightArgumentProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Operator
extends AbstractSchemaObject<Operator>
implements HasParent<OperatorCollection>,
CommutativeOperatorProperty<Operator>,
NegationOperatorProperty<Operator>,
RestrictFunctionProperty<Operator>,
JoinFunctionProperty<Operator>,
HashesProperty<Operator>,
MergesProperty<Operator>,
FunctionProperty<Operator>,
OperatorLeftArgumentProperty<Operator>,
OperatorRightArgumentProperty<Operator>,
OperatorBindingsProperty<Operator> {
    private static final long serialVersionUID = 4636603027166503574L;
    private Operator commutativeOperator = null;
    private Operator negationOperator = null;
    private Function restrictFunction = null;
    private Function joinFunction = null;
    private boolean hashes = (Boolean)SchemaProperties.HASHES.getDefaultValue();
    private boolean merges = (Boolean)SchemaProperties.MERGES.getDefaultValue();
    private Function function = null;
    private OperatorArgument leftArgument = null;
    private OperatorArgument rightArgument = null;
    private OperatorBindingCollection bindings = new OperatorBindingCollection(this);

    public Operator() {
    }

    public Operator(String name) {
        super(name);
    }

    @Override
    protected Supplier<Operator> newInstance() {
        return () -> new Operator();
    }

    @Override
    public String getSpecificName() {
        if (this.leftArgument != null || this.rightArgument != null) {
            StringBuilder builder = new StringBuilder();
            if (this.getName() != null) {
                builder.append(this.getName());
            }
            builder.append("(");
            if (this.leftArgument == null) {
                builder.append(",");
                if (this.rightArgument != null) {
                    builder.append(this.rightArgument.getDataTypeName());
                }
            } else {
                builder.append(this.leftArgument.getDataTypeName());
                builder.append(",");
                if (this.rightArgument != null) {
                    builder.append(this.rightArgument.getDataTypeName());
                }
            }
            builder.append(")");
            return builder.toString();
        }
        return this.getName();
    }

    protected void renewParent() {
        if (this.getParent() != null) {
            this.getParent().renew();
        }
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.FUNCTION_NAME, this.getFunctionName());
        builder.add((ISchemaProperty)SchemaObjectProperties.OPERATOR_LEFT_ARGUMENT, (Object)this.getLeftArgument());
        builder.add((ISchemaProperty)SchemaObjectProperties.OPERATOR_RIGHT_ARGUMENT, (Object)this.getRightArgument());
        builder.add((ISchemaProperty)SchemaProperties.COMMUTATIVE_OPERATOR_NAME, this.getCommutativeOperatorName());
        builder.add((ISchemaProperty)SchemaProperties.NEGATION_OPERATOR_NAME, this.getNegationOperatorName());
        builder.add((ISchemaProperty)SchemaProperties.RESTRICT_FUNCTION_NAME, this.getRestrictFunctionName());
        builder.add((ISchemaProperty)SchemaProperties.JOIN_FUNCTION_NAME, this.getJoinFunctionName());
        if (this.isHashes()) {
            builder.add((ISchemaProperty)SchemaProperties.HASHES, (Object)this.isHashes());
        }
        if (this.isMerges()) {
            builder.add((ISchemaProperty)SchemaProperties.MERGES, (Object)this.isMerges());
        }
    }

    @Override
    protected void writeName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute("name", this.getName());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eq(this.getSchemaName(), this.getFunctionSchemaName())) {
            stax.writeAttribute(SchemaProperties.FUNCTION_NAME.getLabel(), this.getFunctionSchemaName());
        }
        stax.writeAttribute(SchemaProperties.FUNCTION_NAME.getLabel(), this.getFunctionName());
        if (!CommonUtils.eq(this.getSchemaName(), this.getCommutativeOperatorSchemaName())) {
            stax.writeAttribute(SchemaProperties.COMMUTATIVE_OPERATOR_SCHEMA_NAME.getLabel(), this.getCommutativeOperatorSchemaName());
        }
        stax.writeAttribute(SchemaProperties.COMMUTATIVE_OPERATOR_NAME.getLabel(), this.getCommutativeOperatorName());
        if (!CommonUtils.eq(this.getSchemaName(), this.getNegationOperatorSchemaName())) {
            stax.writeAttribute(SchemaProperties.NEGATION_OPERATOR_SCHEMA_NAME.getLabel(), this.getNegationOperatorSchemaName());
        }
        stax.writeAttribute(SchemaProperties.NEGATION_OPERATOR_NAME.getLabel(), this.getNegationOperatorName());
        if (!CommonUtils.eq(this.getSchemaName(), this.getRestrictFunctionSchemaName())) {
            stax.writeAttribute(SchemaProperties.NEGATION_OPERATOR_SCHEMA_NAME.getLabel(), this.getRestrictFunctionSchemaName());
        }
        stax.writeAttribute(SchemaProperties.RESTRICT_FUNCTION_NAME.getLabel(), this.getRestrictFunctionName());
        if (!CommonUtils.eq(this.getSchemaName(), this.getRestrictFunctionSchemaName())) {
            stax.writeAttribute(SchemaProperties.JOIN_FUNCTION_SCHEMA_NAME.getLabel(), this.getJoinFunctionSchemaName());
        }
        stax.writeAttribute(SchemaProperties.JOIN_FUNCTION_NAME.getLabel(), this.getJoinFunctionName());
        if (this.isHashes()) {
            stax.writeAttribute(SchemaProperties.HASHES.getLabel(), (Object)this.isHashes());
        }
        if (this.isMerges()) {
            stax.writeAttribute(SchemaProperties.MERGES.getLabel(), (Object)this.isMerges());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.leftArgument)) {
            this.leftArgument.writeXml(SchemaObjectProperties.OPERATOR_LEFT_ARGUMENT.getLabel(), stax);
        }
        if (!CommonUtils.isEmpty(this.rightArgument)) {
            this.rightArgument.writeXml(SchemaObjectProperties.OPERATOR_RIGHT_ARGUMENT.getLabel(), stax);
        }
        if (!CommonUtils.isEmpty(this.getBindings())) {
            this.getBindings().writeXml(stax);
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Operator)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Operator val = (Operator)obj;
        if (!this.equals(SchemaProperties.FUNCTION_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FUNCTION_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.OPERATOR_BINDINGS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.OPERATOR_LEFT_ARGUMENT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.OPERATOR_RIGHT_ARGUMENT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMMUTATIVE_OPERATOR_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMMUTATIVE_OPERATOR_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.NEGATION_OPERATOR_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.NEGATION_OPERATOR_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.RESTRICT_FUNCTION_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.RESTRICT_FUNCTION_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.JOIN_FUNCTION_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.JOIN_FUNCTION_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.HASHES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MERGES, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    protected Operator setBindings(OperatorBindingCollection bindings) {
        this.bindings = bindings;
        if (bindings != null) {
            bindings.setParent(this);
        }
        return (Operator)this.instance();
    }

    @Override
    public OperatorArgument getLeftArgument() {
        if (this.leftArgument != null) {
            this.leftArgument.setParent(this);
        }
        return this.leftArgument;
    }

    @Override
    public Operator setLeftArgument(OperatorArgument leftArgument) {
        if (this.leftArgument != null) {
            this.leftArgument.setParent(null);
        }
        this.leftArgument = leftArgument;
        if (this.leftArgument != null) {
            this.leftArgument.setDialect(this.getDialect());
            this.leftArgument.setParent(this);
        }
        this.renewParent();
        this.validate();
        return this;
    }

    @Override
    public Operator setLeftArgument(String leftArgument) {
        OperatorArgument argument = new OperatorArgument();
        argument.setParent(this);
        argument.setDialect(this.getDialect());
        argument.setDataTypeName(leftArgument);
        this.leftArgument = argument;
        this.validate();
        return this;
    }

    @Override
    public OperatorArgument getRightArgument() {
        if (this.rightArgument != null) {
            this.leftArgument.setParent(this);
        }
        return this.rightArgument;
    }

    @Override
    public Operator setRightArgument(OperatorArgument rightArgument) {
        if (this.rightArgument != null) {
            this.rightArgument.setParent(null);
        }
        this.rightArgument = rightArgument;
        if (this.rightArgument != null) {
            this.leftArgument.setDialect(this.getDialect());
            this.rightArgument.setParent(this);
        }
        this.renewParent();
        this.validate();
        return this;
    }

    @Override
    public Operator setRightArgument(String rightArgument) {
        OperatorArgument argument = new OperatorArgument();
        argument.setParent(this);
        argument.setDialect(this.getDialect());
        argument.setDataTypeName(rightArgument);
        this.rightArgument = argument;
        this.validate();
        return this;
    }

    @Override
    public boolean isHashes() {
        return this.hashes;
    }

    @Override
    public Operator setHashes(boolean hashes) {
        this.hashes = hashes;
        return this;
    }

    @Override
    public boolean isMerges() {
        return this.merges;
    }

    @Override
    public Operator setMerges(boolean merges) {
        this.merges = merges;
        return this;
    }

    @Override
    public OperatorBindingCollection getBindings() {
        return this.bindings;
    }

    @Override
    public OperatorCollection getParent() {
        return (OperatorCollection)super.getParent();
    }

    @Override
    protected void validate() {
        this.getBindings().validate();
        if (this.leftArgument != null) {
            this.leftArgument.validate();
        }
        if (this.rightArgument != null) {
            this.rightArgument.validate();
        }
    }
}

