/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.OperatorBindingArgumentCollection;
import com.sqlapp.data.schemas.OperatorBindingCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PropertyProperty;
import com.sqlapp.data.schemas.properties.TypeSchemaNameProperty;
import com.sqlapp.data.schemas.properties.complex.ImplementationTypeProperty;
import com.sqlapp.data.schemas.properties.object.OperatorBindingArgumentsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class OperatorBinding
extends AbstractDbObject<OperatorBinding>
implements HasParent<OperatorBindingCollection>,
DataTypeProperties<OperatorBinding>,
TypeSchemaNameProperty<OperatorBinding>,
ImplementationTypeProperty<OperatorBinding>,
OperatorBindingArgumentsProperty<OperatorBinding>,
PropertyProperty<OperatorBinding> {
    private static final long serialVersionUID = 8186027542736225676L;
    private OperatorBindingArgumentCollection arguments = new OperatorBindingArgumentCollection(this);
    private String typeSchemaName = null;
    private DataType dataType = null;
    private String dataTypeName = null;
    private Type implementationType = null;
    private String property = null;

    public OperatorBinding() {
    }

    public OperatorBinding(String dataTypeName) {
        this.setDataTypeName(dataTypeName);
    }

    @Override
    protected Supplier<OperatorBinding> newInstance() {
        return () -> new OperatorBinding();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.TYPE_SCHEMA_NAME.getLabel(), this.getTypeSchemaName());
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        stax.writeAttribute(SchemaProperties.IMPLEMENTATION_TYPE_SCHEMA_NAME.getLabel(), this.getImplementationTypeSchemaName());
        stax.writeAttribute(SchemaProperties.IMPLEMENTATION_TYPE_NAME.getLabel(), this.getImplementationTypeName());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.getArguments())) {
            this.getArguments().writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    @Override
    protected String getSimpleName() {
        return "binding";
    }

    protected OperatorBinding setArguments(OperatorBindingArgumentCollection arguments) {
        this.arguments = arguments;
        if (arguments != null) {
            arguments.setParent(this);
        }
        return (OperatorBinding)this.instance();
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.getDataType());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.getDataTypeName());
        builder.add((ISchemaProperty)SchemaProperties.PROPERTY, this.getProperty());
        super.toString(builder);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof OperatorBinding)) {
            return false;
        }
        OperatorBinding val = (OperatorBinding)obj;
        if (!this.equals(SchemaProperties.TYPE_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.ARGUMENTS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.IMPLEMENTATION_TYPE_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.IMPLEMENTATION_TYPE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PROPERTY, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public OperatorBindingCollection getParent() {
        return (OperatorBindingCollection)super.getParent();
    }

    @Override
    public int compareTo(OperatorBinding o) {
        return 0;
    }

    @Override
    public String getTypeSchemaName() {
        return this.typeSchemaName;
    }

    @Override
    public OperatorBinding setTypeSchemaName(String typeSchemaName) {
        this.typeSchemaName = typeSchemaName;
        return (OperatorBinding)this.instance();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public OperatorBinding setDataType(DataType dataType) {
        this.dataType = dataType;
        return (OperatorBinding)this.instance();
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public OperatorBinding setProperty(String property) {
        this.property = property;
        return (OperatorBinding)this.instance();
    }

    @Override
    public OperatorBindingArgumentCollection getArguments() {
        return this.arguments;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof OperatorBinding)) {
            return false;
        }
        OperatorBinding cst = (OperatorBinding)obj;
        return CommonUtils.eq(this.getOrdinal(), cst.getOrdinal());
    }

    @Override
    protected void validate() {
        super.validate();
    }
}

