/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.PartitionCollection;
import com.sqlapp.data.schemas.PartitionFunction;
import com.sqlapp.data.schemas.PartitionScheme;
import com.sqlapp.data.schemas.PartitioningHandler;
import com.sqlapp.data.schemas.PartitioningType;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PartitionSizeProperty;
import com.sqlapp.data.schemas.properties.PartitioningTypeProperty;
import com.sqlapp.data.schemas.properties.SubPartitionSizeProperty;
import com.sqlapp.data.schemas.properties.SubPartitioningTypeProperty;
import com.sqlapp.data.schemas.properties.complex.PartitionSchemeProperty;
import com.sqlapp.data.schemas.properties.object.PartitioningColumnsProperty;
import com.sqlapp.data.schemas.properties.object.PartitionsProperty;
import com.sqlapp.data.schemas.properties.object.SubPartitioningColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Partitioning
extends AbstractDbObject<Partitioning>
implements HasParent<AbstractSchemaObject<?>>,
PartitionSchemeProperty<Partitioning>,
PartitioningTypeProperty<Partitioning>,
SubPartitioningTypeProperty<Partitioning>,
PartitionSizeProperty<Partitioning>,
SubPartitionSizeProperty<Partitioning>,
PartitioningColumnsProperty<Partitioning>,
SubPartitioningColumnsProperty<Partitioning>,
PartitionsProperty<Partitioning> {
    private static final long serialVersionUID = 8518120516204639184L;
    private Table table = null;
    private Index index = null;
    private PartitionScheme partitionScheme = null;
    private PartitioningType partitioningType = null;
    private PartitioningType subPartitioningType = null;
    private ReferenceColumnCollection partitioningColumns = new ReferenceColumnCollection(this);
    private ReferenceColumnCollection subPartitioningColumns = new ReferenceColumnCollection(this);
    private PartitionCollection partitions = new PartitionCollection(this);
    private final List<Table> partitionTables = CommonUtils.list();
    private Integer partitionSize = null;
    private Integer subPartitionSize = null;

    public Partitioning() {
    }

    public Partitioning(PartitioningType partitioningType) {
        this.partitioningType = partitioningType;
    }

    protected Partitioning(AbstractSchemaObject<?> parent) {
        this.setParent(parent);
    }

    @Override
    protected Supplier<Partitioning> newInstance() {
        return () -> new Partitioning();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof Partitioning)) {
            return false;
        }
        Partitioning val = (Partitioning)obj;
        if (!this.equals(SchemaProperties.PARTITIONING_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SUB_PARTITIONING_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.PARTITIONING_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.SUB_PARTITIONING_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PARTITION_SIZE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SUB_PARTITION_SIZE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.PARTITIONS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PARTITION_SCHEME_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.PARTITIONING_TYPE, (Object)this.getPartitioningType());
        builder.add((ISchemaProperty)SchemaProperties.PARTITION_SCHEME_NAME, this.getPartitionSchemeName());
        builder.add((ISchemaProperty)SchemaProperties.SUB_PARTITIONING_TYPE, (Object)this.getSubPartitioningType());
        builder.add((ISchemaProperty)SchemaObjectProperties.PARTITIONING_COLUMNS, (Object)this.getPartitioningColumns());
        builder.add((ISchemaProperty)SchemaObjectProperties.SUB_PARTITIONING_COLUMNS, (Object)this.getSubPartitioningColumns());
        builder.add((ISchemaProperty)SchemaObjectProperties.PARTITIONS, (Object)this.getPartitions());
        super.toString(builder);
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        builder.add((ISchemaProperty)SchemaProperties.PARTITIONING_TYPE, (Object)this.getPartitioningType());
        builder.add((ISchemaProperty)SchemaProperties.PARTITION_SCHEME_NAME, this.getPartitionSchemeName());
        builder.add((ISchemaProperty)SchemaProperties.SUB_PARTITIONING_TYPE, (Object)this.getSubPartitioningType());
        if (!CommonUtils.isEmpty(this.getPartitioningColumns())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.PARTITIONING_COLUMNS, this.getPartitioningColumns().toStringSimple());
        }
        if (!CommonUtils.isEmpty(this.getSubPartitioningColumns())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.SUB_PARTITIONING_COLUMNS, this.getSubPartitioningColumns().toStringSimple());
        }
        return builder.toString();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.PARTITION_SCHEME_NAME.getLabel(), this.getPartitionSchemeName());
        stax.writeAttribute(SchemaProperties.PARTITIONING_TYPE.getLabel(), (Object)this.getPartitioningType());
        stax.writeAttribute(SchemaProperties.SUB_PARTITIONING_TYPE.getLabel(), (Object)this.getSubPartitioningType());
        stax.writeAttribute(SchemaProperties.PARTITION_SIZE.getLabel(), (Object)this.getPartitionSize());
        stax.writeAttribute(SchemaProperties.SUB_PARTITION_SIZE.getLabel(), (Object)this.getSubPartitionSize());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.partitioningColumns)) {
            this.partitioningColumns.writeXml(SchemaObjectProperties.PARTITIONING_COLUMNS.getLabel(), stax);
        }
        if (!CommonUtils.isEmpty(this.subPartitioningColumns)) {
            this.subPartitioningColumns.writeXml(SchemaObjectProperties.SUB_PARTITIONING_COLUMNS.getLabel(), stax);
        }
        if (!CommonUtils.isEmpty(this.partitions)) {
            this.partitions.writeXml(stax);
        }
    }

    @Override
    public PartitioningType getPartitioningType() {
        return this.partitioningType;
    }

    @Override
    public Partitioning setPartitioningType(PartitioningType partitioningType) {
        this.partitioningType = partitioningType;
        return (Partitioning)this.instance();
    }

    @Override
    public PartitioningType getSubPartitioningType() {
        return this.subPartitioningType;
    }

    @Override
    public Partitioning setSubPartitioningType(PartitioningType subPartitioningType) {
        this.subPartitioningType = subPartitioningType;
        return (Partitioning)this.instance();
    }

    @Override
    public ReferenceColumnCollection getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public Partitioning setPartitioningColumns(ReferenceColumnCollection partitioningColumns) {
        if (partitioningColumns != null) {
            partitioningColumns.setParent(this);
        }
        this.partitioningColumns = partitioningColumns;
        return (Partitioning)this.instance();
    }

    @Override
    public ReferenceColumnCollection getSubPartitioningColumns() {
        return this.subPartitioningColumns;
    }

    public Partitioning setSubpartitioningColumns(ReferenceColumnCollection subpartitioningColumns) {
        if (subpartitioningColumns != null) {
            subpartitioningColumns.setParent(this);
        }
        this.subPartitioningColumns = subpartitioningColumns;
        return (Partitioning)this.instance();
    }

    public Table getTable() {
        return this.table;
    }

    protected void setTable(Table table) {
        this.partitioningColumns.setTable(table);
        this.subPartitioningColumns.setTable(table);
        this.table = table;
    }

    public Index getIndex() {
        return this.index;
    }

    protected void setIndex(Index index) {
        this.partitioningColumns.setTable(index.getTable());
        this.subPartitioningColumns.setTable(index.getTable());
        this.index = index;
    }

    @Override
    public AbstractSchemaObject<?> getParent() {
        return (AbstractSchemaObject)super.getParent();
    }

    @Override
    protected Partitioning setParent(AbstractSchemaObject<?> parent) {
        if (parent instanceof Table) {
            this.table = (Table)parent;
        } else if (parent instanceof Index) {
            this.index = (Index)parent;
        }
        super.setParent(parent);
        return (Partitioning)this.instance();
    }

    protected Partitioning setSubPartitioningColumns(ReferenceColumnCollection subPartitioningColumns) {
        this.subPartitioningColumns = subPartitioningColumns;
        if (subPartitioningColumns != null) {
            subPartitioningColumns.setParent(this);
        }
        return (Partitioning)this.instance();
    }

    protected Partitioning setPartitions(PartitionCollection partitions) {
        this.partitions = partitions;
        if (partitions != null) {
            partitions.setParent(this);
        }
        return (Partitioning)this.instance();
    }

    @Override
    public PartitionCollection getPartitions() {
        return this.partitions;
    }

    public List<Table> getPartitionTables() {
        return Collections.unmodifiableList(this.partitionTables);
    }

    protected void addPartitionTable(Table table) {
        if (this.partitionTables.contains(table)) {
            return;
        }
        this.partitionTables.add(table);
        this.partitionTables.sort((o1, o2) -> o1.compareTo(o2));
    }

    protected void addAllPartitionTable(Collection<Table> tables) {
        tables.forEach(table -> {
            if (this.partitionTables.contains(table)) {
                return;
            }
            this.partitionTables.add((Table)table);
        });
        this.partitionTables.sort((o1, o2) -> o1.compareTo(o2));
    }

    protected void removePartitionTable(Table table) {
        if (!this.partitionTables.contains(table)) {
            return;
        }
        this.partitionTables.remove(table);
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        this.partitioningColumns.setCaseSensitive(caseSensitive);
        this.subPartitioningColumns.setCaseSensitive(caseSensitive);
    }

    @Override
    public int compareTo(Partitioning o) {
        return 0;
    }

    @Override
    public Integer getPartitionSize() {
        if (CommonUtils.isEmpty(this.getPartitions())) {
            return this.partitionSize;
        }
        return this.getPartitions().size();
    }

    @Override
    public Partitioning setPartitionSize(Integer partitionSize) {
        this.partitionSize = partitionSize;
        return (Partitioning)this.instance();
    }

    @Override
    public Integer getSubPartitionSize() {
        return this.subPartitionSize;
    }

    @Override
    public Partitioning setSubPartitionSize(Integer subpartitionSize) {
        this.subPartitionSize = subpartitionSize;
        return (Partitioning)this.instance();
    }

    protected PartitioningHandler getDbObjectXmlReaderHandler() {
        return new PartitioningHandler();
    }

    @Override
    protected void validate() {
        Catalog catalog;
        if (this.partitionScheme != null && (catalog = this.getAncestor(Catalog.class)) != null && !CommonUtils.isEmpty(catalog.getPartitionSchemes())) {
            PartitionScheme partitionScheme = (PartitionScheme)catalog.getPartitionSchemes().get(this.partitionScheme.getName());
            if (this.partitionScheme != partitionScheme) {
                this.partitionScheme = partitionScheme;
            }
            this.generatePartitionsByPartitionScheme();
        }
    }

    private void generatePartitionsByPartitionScheme() {
        if (this.getPartitionScheme() == null) {
            return;
        }
        this.getPartitions().clear();
        PartitionScheme partitionScheme = this.getPartitionScheme();
        PartitionFunction partitionFunction = partitionScheme.getPartitionFunction();
        for (int i = 0; i < partitionScheme.getTableSpaces().size(); ++i) {
            TableSpace tableSpace = (TableSpace)this.getPartitionScheme().getTableSpaces().get(i);
            Partition partition = new Partition();
            partition.setName(tableSpace.getId());
            tableSpace.setId(null);
            if (partitionFunction.isBoundaryValueOnRight()) {
                partition.setHighValueInclusive(true);
            }
            partition.setVirtual(true);
            if (i < partitionFunction.getValues().size()) {
                String value = (String)partitionFunction.getValues().get(i);
                partition.setHighValue(value);
            }
            partition.setTableSpace(tableSpace);
            this.getPartitions().add(partition);
        }
    }
}

