/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum PrivilegeState {
    Grant("G.*"),
    Deny("D.*"),
    Revoke("R.*");

    Pattern pattern;

    private PrivilegeState(String patternText) {
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static PrivilegeState parse(String text) {
        if (text == null) {
            return null;
        }
        for (PrivilegeState state : PrivilegeState.values()) {
            Matcher matcher = state.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return state;
        }
        return null;
    }
}

