/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.PublicSynonymCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DbLinkNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.SynonymProperties;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class PublicSynonym
extends AbstractNamedObject<PublicSynonym>
implements HasParent<PublicSynonymCollection>,
SynonymProperties<PublicSynonym>,
DbLinkNameProperty<PublicSynonym> {
    private static final long serialVersionUID = -4906000020243009507L;
    private String objectSchemaName = null;
    private String objectName = null;
    private String dbLinkName = null;

    protected PublicSynonym() {
    }

    public PublicSynonym(String name) {
        super(name);
    }

    @Override
    protected Supplier<PublicSynonym> newInstance() {
        return () -> new PublicSynonym();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.OBJECT_SCHEMA_NAME, this.getObjectSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.OBJECT_NAME, this.getObjectName());
        builder.add((ISchemaProperty)SchemaProperties.DB_LINK_NAME, this.getDbLinkName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof PublicSynonym)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        PublicSynonym val = (PublicSynonym)obj;
        if (!this.equals(SchemaProperties.OBJECT_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OBJECT_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DB_LINK_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public String getObjectSchemaName() {
        return this.objectSchemaName;
    }

    @Override
    public PublicSynonym setObjectSchemaName(String objectSchemaName) {
        this.objectSchemaName = objectSchemaName;
        return (PublicSynonym)this.instance();
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public PublicSynonym setObjectName(String objectName) {
        this.objectName = objectName;
        return (PublicSynonym)this.instance();
    }

    @Override
    public PublicSynonym setDbLinkName(String dbLinkName) {
        this.dbLinkName = dbLinkName;
        return (PublicSynonym)this.instance();
    }

    @Override
    public String getDbLinkName() {
        return this.dbLinkName;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.OBJECT_SCHEMA_NAME.getLabel(), this.getObjectSchemaName());
        stax.writeAttribute(SchemaProperties.OBJECT_NAME.getLabel(), this.getObjectName());
        stax.writeAttribute(SchemaProperties.DB_LINK_NAME.getLabel(), this.getDbLinkName());
    }

    @Override
    public PublicSynonymCollection getParent() {
        return (PublicSynonymCollection)super.getParent();
    }

    public Table getTable() {
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return null;
        }
        Schema schema = (Schema)catalog.getSchemas().get(this.getObjectSchemaName());
        if (schema == null) {
            return null;
        }
        return (Table)schema.getTables().get(this.getObjectName());
    }
}

