/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.NullsOrder;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UnOrdered;
import com.sqlapp.data.schemas.properties.SchemaNameGetter;
import com.sqlapp.data.schemas.properties.TableNameGetter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ReferenceColumnCollection
extends AbstractNamedObjectCollection<ReferenceColumn>
implements UnOrdered,
SchemaNameGetter,
TableNameGetter,
HasParent<AbstractDbObject<?>>,
NewElement<ReferenceColumn, ReferenceColumnCollection> {
    private static final long serialVersionUID = 8912043724651049178L;

    protected ReferenceColumnCollection() {
    }

    protected ReferenceColumnCollection(AbstractDbObject<?> parent) {
        super(parent);
    }

    @Override
    protected Supplier<ReferenceColumnCollection> newInstance() {
        return () -> new ReferenceColumnCollection();
    }

    @Override
    public Iterator<ReferenceColumn> iterator() {
        super.renew();
        return super.iterator();
    }

    @Override
    public ListIterator<ReferenceColumn> listIterator() {
        super.renew();
        return super.listIterator();
    }

    @Override
    public ReferenceColumn get(String name) {
        ReferenceColumn column = (ReferenceColumn)super.get(name);
        if (column != null && CommonUtils.eqIgnoreCase(name, column.getName())) {
            return column;
        }
        super.renew();
        return (ReferenceColumn)super.get(name);
    }

    @Override
    public List<ReferenceColumn> getAll(String ... names) {
        super.renew();
        return super.getAll(names);
    }

    @Override
    public List<ReferenceColumn> getAll(List<String> names) {
        super.renew();
        return super.getAll(names);
    }

    @Override
    public List<ReferenceColumn> getAll(Collection<String> names) {
        super.renew();
        return super.getAll(names);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ReferenceColumnCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    public ReferenceColumn add(String name) {
        return this.add(name, (ReferenceColumn col) -> {});
    }

    public ReferenceColumn add(String name, Consumer<ReferenceColumn> cons) {
        Column column;
        if (this.getTable() != null && (column = (Column)this.getTable().getColumns().get(name)) != null) {
            ReferenceColumn rColumn = new ReferenceColumn(column);
            super.add(rColumn);
            cons.accept(rColumn);
            return rColumn;
        }
        ReferenceColumn rColumn = new ReferenceColumn(name);
        super.add(rColumn);
        this.validate();
        cons.accept(rColumn);
        return rColumn;
    }

    public ReferenceColumn add(Column column) {
        Column orgColumn;
        if (this.getTable() != null && (orgColumn = (Column)this.getTable().getColumns().get(column.getName())) != null) {
            ReferenceColumn rColumn = new ReferenceColumn(orgColumn);
            super.add(rColumn);
            return rColumn;
        }
        ReferenceColumn rColumn = new ReferenceColumn(column);
        super.add(rColumn);
        this.validate();
        return rColumn;
    }

    public void addAll(Column ... columns) {
        for (Column column : columns) {
            super.add(new ReferenceColumn(column));
        }
        this.validate();
    }

    public ReferenceColumn add(String name, Order order) {
        ReferenceColumn rColumn = this.add(name);
        rColumn.setOrder(order);
        return rColumn;
    }

    public ReferenceColumn add(String name, NullsOrder nullsOrder) {
        ReferenceColumn rColumn = this.add(name);
        rColumn.setNullsOrder(nullsOrder);
        return rColumn;
    }

    public ReferenceColumn add(Column column, Order order) {
        ReferenceColumn rColumn = this.add(column);
        rColumn.setOrder(order);
        return rColumn;
    }

    public ReferenceColumn add(Column column, NullsOrder nullsOrder) {
        ReferenceColumn rColumn = this.add(column);
        rColumn.setNullsOrder(nullsOrder);
        return rColumn;
    }

    public ReferenceColumn add(Column column, boolean includedColumn) {
        ReferenceColumn rColumn = this.add(column);
        rColumn.setIncludedColumn(includedColumn);
        return rColumn;
    }

    public ReferenceColumnCollection add(String ... names) {
        int size = names.length;
        for (int i = 0; i < size; ++i) {
            this.add(names[i]);
        }
        return this;
    }

    public void addAll(List<String> c) {
        for (String str : c) {
            this.add(str);
        }
    }

    @Override
    public boolean remove(String o) {
        this.renew();
        boolean bool = super.remove(o);
        this.validate();
        return bool;
    }

    public Table getTable() {
        String schemaName = null;
        String tableName = null;
        Table obj = null;
        for (ReferenceColumn refColumn : this) {
            if (refColumn.getColumn() != null) {
                obj = refColumn.getColumn().getTable();
            }
            if (obj != null) {
                return obj;
            }
            if (refColumn.getSchemaName() != null) {
                schemaName = refColumn.getTableName();
            }
            if (refColumn.getTableName() == null) continue;
            tableName = refColumn.getTableName();
            break;
        }
        Schema schema = null;
        if (schemaName == null) {
            schema = this.getAncestor(Schema.class);
        } else {
            SchemaCollection schemas = this.getAncestor(SchemaCollection.class);
            if (schemas != null) {
                schema = (Schema)schemas.get(schemaName);
            }
        }
        obj = schema == null ? this.getAncestor(Table.class) : schema.getTable(tableName);
        return obj;
    }

    public Index getIndex() {
        return this.getAncestor(Index.class);
    }

    @Override
    public AbstractDbObject<?> getParent() {
        return (AbstractDbObject)super.getParent();
    }

    @Override
    protected ReferenceColumnCollection setParent(AbstractSchemaObject<?> parent) {
        super.setParent(parent);
        if (parent instanceof Table) {
            this.setTable((Table)parent);
        }
        return this.instance();
    }

    private ReferenceColumnCollection instance() {
        return this;
    }

    protected ReferenceColumnCollection setTable(Table table) {
        if (table == null) {
            return this.instance();
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rColumn = (ReferenceColumn)this.get(i);
            rColumn.setTableName(null);
            Column column = (Column)table.getColumns().get(rColumn.getName());
            if (column == null) continue;
            rColumn.setColumn(column);
        }
        return this;
    }

    @Override
    public ReferenceColumnCollection clone() {
        return (ReferenceColumnCollection)super.clone();
    }

    public List<Column> toColumns() {
        List<Column> list = CommonUtils.list(this.size());
        for (ReferenceColumn rCol : this) {
            list.add(rCol.getColumn());
        }
        return list;
    }

    @Override
    public void sort() {
    }

    @Override
    public String toStringSimple() {
        SeparatedStringBuilder sep = new SeparatedStringBuilder(", ");
        sep.setStart("(").setEnd(")");
        for (ReferenceColumn column : this) {
            StringBuilder builder = new StringBuilder(column.getName());
            if (column.getOrder() != null) {
                if (Order.Asc != column.getOrder()) {
                    builder.append(" ");
                    builder.append(column.getOrder());
                }
                if (column.getNullsOrder() != null) {
                    builder.append(" ");
                    builder.append(column.getNullsOrder());
                }
                if (column.isIncludedColumn()) {
                    builder.append(" included");
                }
            }
            sep.add((Object)builder.toString());
        }
        return sep.toString();
    }

    @Override
    protected ReferenceColumnCollectionXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new ReferenceColumnCollectionXmlReaderHandler();
    }

    @Override
    public String getTableName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getSchemaName();
        }
        return null;
    }

    @Override
    protected void validate() {
        super.validate();
    }

    @Override
    public ReferenceColumn newElement() {
        return (ReferenceColumn)super.newElementInternal();
    }

    @Override
    protected Supplier<ReferenceColumn> getElementSupplier() {
        return () -> new ReferenceColumn();
    }
}

