/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum SavepointLevel implements EnumProperties
{
    NewSavePointLevel("NEW SAVEPOINT LEVEL", "NEW.*"),
    OldSavePointLevel("OLD SAVEPOINT LEVEL", "OLD.*");

    private final Pattern pattern;
    private final String text;

    private SavepointLevel(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static SavepointLevel parse(String text) {
        if (text == null) {
            return null;
        }
        for (SavepointLevel rule : SavepointLevel.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    public String getValue() {
        return this.text;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

