/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.SchemaObjectNameHolder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.function.Predicate;

public class SchemaObjectFilter
implements Predicate<AbstractSchemaObject<?>> {
    private String[] includes = null;
    private String[] excludes = null;
    private boolean defaultInclude = false;
    private List<SchemaObjectNameHolder> includeList = CommonUtils.list();
    private List<SchemaObjectNameHolder> excludeList = CommonUtils.list();

    @Override
    public boolean test(AbstractSchemaObject<?> obj) {
        return this.match(obj.getCatalogName(), obj.getSchemaName(), obj.getName());
    }

    private boolean match(String catalogName, String schemaName, String name) {
        if (this.excludeList.size() > 0 && this.find(catalogName, schemaName, name, this.excludeList)) {
            return false;
        }
        if (this.includeList.size() > 0 && this.find(catalogName, schemaName, name, this.includeList)) {
            return true;
        }
        return this.isDefaultInclude();
    }

    private boolean find(String catalogName, String schemaName, String name, List<SchemaObjectNameHolder> list) {
        for (SchemaObjectNameHolder objectNameHolder : list) {
            if (!objectNameHolder.match(catalogName, schemaName, name)) continue;
            return true;
        }
        return false;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String ... includes) {
        this.includeList.clear();
        if (includes != null) {
            for (String arg : includes) {
                SchemaObjectNameHolder nameHolder = new SchemaObjectNameHolder(arg);
                this.includeList.add(nameHolder);
            }
        }
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String ... excludes) {
        this.excludeList.clear();
        if (excludes != null) {
            for (String arg : excludes) {
                SchemaObjectNameHolder nameHolder = new SchemaObjectNameHolder(arg);
                this.excludeList.add(nameHolder);
            }
        }
        this.excludes = excludes;
    }

    public boolean isDefaultInclude() {
        return this.defaultInclude;
    }

    public void setDefaultInclude(boolean defaultInclude) {
        this.defaultInclude = defaultInclude;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("includes", (Object)this.includes);
        builder.add("excludes", (Object)this.excludes);
        return builder.toString();
    }
}

