/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.util.CommonUtils;

public enum State {
    Unchanged{

        @Override
        public boolean isChanged() {
            return false;
        }
    }
    ,
    Added{

        @Override
        public boolean isAdded() {
            return true;
        }

        @Override
        public State reverse() {
            return Deleted;
        }
    }
    ,
    Modified{

        @Override
        public boolean isModified() {
            return true;
        }
    }
    ,
    Deleted{

        @Override
        public State reverse() {
            return Added;
        }

        @Override
        public boolean isDeleted() {
            return true;
        }
    };


    public boolean isAdded() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isChanged() {
        return true;
    }

    public State reverse() {
        return this;
    }

    public static State getState(Object original, Object target) {
        if (!CommonUtils.eq(original, target)) {
            if (original == null) {
                return Added;
            }
            if (target == null) {
                return Deleted;
            }
            return Modified;
        }
        return Unchanged;
    }
}

