/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Locale;

public enum Statistics {
    ROWS{}
    ,
    DATA_LENGTH_MBYTES{

        @Override
        public <T> T getValue(StatisticsProperty<?> obj) {
            Long value = (Long)DATA_LENGTH.getValue(obj);
            if (value == null) {
                return null;
            }
            Long ret = value / (long)CommonUtils.LEN_1MB;
            return (T)ret;
        }
    }
    ,
    DATA_LENGTH_GBYTES{

        @Override
        public <T> T getValue(StatisticsProperty<?> obj) {
            Long value = (Long)DATA_LENGTH.getValue(obj);
            if (value == null) {
                return null;
            }
            Long ret = value / (long)CommonUtils.LEN_1GB;
            return (T)ret;
        }
    }
    ,
    AVG_ROW_LENGTH{}
    ,
    AVG_COMPRESSED_ROW_LENGTH{}
    ,
    AVG_ROW_COMPRESSION_RAITO{

        @Override
        protected Class<?> getType() {
            return Float.class;
        }
    }
    ,
    ROW_COMPRESSED{

        @Override
        protected Class<?> getType() {
            return Float.class;
        }
    }
    ,
    DATA_LENGTH{

        @Override
        public <T> T getValue(StatisticsProperty<?> obj) {
            Long ret = (Long)this.getValueInternal(obj);
            if (ret != null) {
                return (T)ret;
            }
            Long value1 = (Long)ROWS.getValue(obj);
            Long value2 = (Long)AVG_ROW_LENGTH.getValue(obj);
            if (value1 != null && value2 != null) {
                ret = value1 * value2;
                return (T)ret;
            }
            return null;
        }
    }
    ,
    MAX_DATA_LENGTH{}
    ,
    INDEX_LENGTH{}
    ,
    LOB_LENGTH{};


    public <T> T getValue(StatisticsProperty<?> obj) {
        return this.getValueInternal(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormatedValue(StatisticsProperty<?> obj, Locale locale) {
        Object value = this.getValueInternal(obj);
        if (value == null) {
            return "";
        }
        if (value instanceof Integer || value instanceof Long) {
            NumberFormat format = locale == null ? NumberFormat.getInstance() : NumberFormat.getNumberInstance(locale);
            NumberFormat numberFormat = format;
            synchronized (numberFormat) {
                return format.format(value);
            }
        }
        return value.toString();
    }

    protected <T> T getValueInternal(StatisticsProperty<?> obj) {
        return (T)obj.getStatistics().get(this.toString(), this.getType());
    }

    protected Class<?> getType() {
        return Long.class;
    }

    public void setValue(ExResultSet rs, String columnKey, StatisticsProperty<?> obj) throws SQLException {
        this.setValue(rs, columnKey, this.toString(), obj);
    }

    public void setValue(StatisticsProperty<?> obj, Object value) {
        String statisticsKey = this.toString();
        obj.getStatistics().remove(statisticsKey);
        obj.getStatistics().put(statisticsKey, value);
    }

    protected void setValue(ExResultSet rs, String columnKey, String statisticsKey, StatisticsProperty<?> obj) throws SQLException {
        Class<?> clazz = this.getType();
        if (clazz == Long.class) {
            this.setLongValue(rs, columnKey, statisticsKey, obj);
        } else if (clazz == Float.class) {
            this.setFloatValue(rs, columnKey, statisticsKey, obj);
        }
    }

    protected void setLongValue(ExResultSet rs, String columnKey, String statisticsKey, StatisticsProperty<?> obj) throws SQLException {
        Long value = rs.getLongValue(columnKey);
        if (value == null) {
            obj.getStatistics().remove(statisticsKey);
        } else if (value.compareTo(0L) < 0) {
            obj.getStatistics().remove(statisticsKey);
        } else {
            obj.getStatistics().put(statisticsKey, (Object)value);
        }
    }

    protected void setFloatValue(ExResultSet rs, String columnKey, String statisticsKey, StatisticsProperty<?> obj) throws SQLException {
        Float value = rs.getFloatValue(columnKey);
        if (value == null) {
            obj.getStatistics().remove(statisticsKey);
        } else if (value.compareTo(Float.valueOf(0.0f)) < 0) {
            obj.getStatistics().remove(statisticsKey);
        } else {
            obj.getStatistics().put(statisticsKey, (Object)value);
        }
    }
}

