/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public final class StaxWriterUtils {
    public static void writeColumnSimple(StaxWriter stax, NameProperty<?> column) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeStartElement("column");
        stax.writeAttribute("name", column.getName());
        stax.writeEndElement();
    }

    public static void writeColumnSimple(StaxWriter stax, ReferenceColumn ... columns) throws XMLStreamException {
        for (ReferenceColumn column : columns) {
            StaxWriterUtils.writeColumnSimple(stax, column);
        }
    }

    @SafeVarargs
    public static <T extends NameProperty<?>> void writeColumnSimple(StaxWriter stax, T ... columns) throws XMLStreamException {
        for (T column : columns) {
            StaxWriterUtils.writeColumnSimple(stax, column);
        }
    }

    public static void writeColumnSimple(StaxWriter stax, Collection<? extends NameProperty<?>> c) throws XMLStreamException {
        for (NameProperty<?> prop : c) {
            StaxWriterUtils.writeColumnSimple(stax, prop);
        }
    }

    public static void write(StaxWriter stax, String elemnentName, List<String> text) throws XMLStreamException {
        if (!CommonUtils.isEmpty(text)) {
            stax.newLine();
            stax.indent();
            stax.writeElement(elemnentName, text);
        }
    }
}

