/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.PublicSynonym;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SynonymCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DbLinkNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.ObjectNameProperty;
import com.sqlapp.data.schemas.properties.ObjectSchemaNameProperty;
import com.sqlapp.data.schemas.properties.SynonymProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Synonym
extends AbstractSchemaObject<Synonym>
implements HasParent<SynonymCollection>,
SynonymProperties<Synonym>,
ObjectSchemaNameProperty<Synonym>,
ObjectNameProperty<Synonym>,
DbLinkNameProperty<Synonym> {
    private static final long serialVersionUID = -4906000020243009507L;
    private String objectSchemaName = null;
    private String objectName = null;
    private String dbLinkName = null;

    protected Synonym() {
    }

    public Synonym(String name) {
        super(name);
    }

    @Override
    protected Supplier<Synonym> newInstance() {
        return () -> new Synonym();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.OBJECT_SCHEMA_NAME, this.getObjectSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.OBJECT_NAME, this.getObjectName());
        builder.add((ISchemaProperty)SchemaProperties.DB_LINK_NAME, this.getDbLinkName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Synonym)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Synonym val = (Synonym)obj;
        if (!this.equals(SchemaProperties.OBJECT_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OBJECT_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DB_LINK_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public String getObjectSchemaName() {
        return this.objectSchemaName;
    }

    @Override
    public Synonym setObjectSchemaName(String objectSchemaName) {
        this.objectSchemaName = objectSchemaName;
        return (Synonym)this.instance();
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public Synonym setObjectName(String objectName) {
        this.objectName = objectName;
        return (Synonym)this.instance();
    }

    @Override
    public Synonym setDbLinkName(String dbLinkName) {
        this.dbLinkName = dbLinkName;
        return (Synonym)this.instance();
    }

    @Override
    public String getDbLinkName() {
        return this.dbLinkName;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.OBJECT_SCHEMA_NAME.getLabel(), this.getObjectSchemaName());
        stax.writeAttribute(SchemaProperties.OBJECT_NAME.getLabel(), this.getObjectName());
        stax.writeAttribute(SchemaProperties.DB_LINK_NAME.getLabel(), this.getDbLinkName());
    }

    @Override
    public SynonymCollection getParent() {
        return (SynonymCollection)super.getParent();
    }

    public Synonym nextSynonym() {
        if (this.getParent() == null) {
            return null;
        }
        if (CommonUtils.eq(this.getSchemaName(), this.getObjectSchemaName())) {
            return (Synonym)this.getParent().get(this.getObjectName());
        }
        SchemaCollection schemas = this.getAncestor(SchemaCollection.class);
        if (schemas == null) {
            return null;
        }
        Schema schema = (Schema)schemas.get(this.getObjectSchemaName());
        if (schema == null) {
            return null;
        }
        return (Synonym)schema.getSynonyms().get(this.getObjectSchemaName());
    }

    public PublicSynonym nextPublicSynonym() {
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return null;
        }
        return (PublicSynonym)catalog.getPublicSynonyms().get(this.getObjectName());
    }

    public Synonym rootSynonym() {
        Synonym next = this;
        Synonym current;
        while ((current = next.nextSynonym()) != null) {
            next = current;
        }
        return next;
    }

    public Table getTable() {
        Schema schema = this.getAncestor(Schema.class);
        if (schema == null) {
            return null;
        }
        if (CommonUtils.eq(this.getSchemaName(), this.getObjectSchemaName())) {
            return schema.getTable(this.getObjectName());
        }
        return (Table)schema.getTables().get(this.getObjectName());
    }
}

