/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import java.util.List;
import java.util.function.Supplier;

public class TableCollection
extends AbstractSchemaObjectCollection<Table>
implements HasParent<Schema>,
RowIteratorHandlerProperty,
NewElement<Table, TableCollection> {
    private static final long serialVersionUID = -2475015269706867532L;

    protected TableCollection() {
    }

    protected TableCollection(Schema parent) {
        super(parent);
    }

    @Override
    protected Supplier<TableCollection> newInstance() {
        return () -> new TableCollection();
    }

    @Override
    public TableCollection clone() {
        return (TableCollection)super.clone();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof TableCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public Schema getParent() {
        return this.getSchema();
    }

    @Override
    protected TableCollectionXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new TableCollectionXmlReaderHandler();
    }

    @Override
    public void setAddDbObjectPredicate(AddDbObjectPredicate addDbObjectFilter) {
        super.setAddDbObjectPredicate(addDbObjectFilter);
        for (Table table : this) {
            table.setAddDbObjectFilter(addDbObjectFilter);
        }
    }

    @Override
    public void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        for (Table table : this) {
            table.setRowIteratorHandler(rowIteratorHandler);
        }
    }

    public TableCollection sortAsCreateOrder() {
        List<Table> c = SchemaUtils.getNewSortedList(this.inner, Table.TableOrder.CREATE.getComparator());
        this.inner.clear();
        this.inner.addAll(c);
        this.renew();
        return this;
    }

    public TableCollection sortAsDropOrder() {
        List<Table> c = SchemaUtils.getNewSortedList(this.inner, Table.TableOrder.DROP.getComparator());
        this.inner.clear();
        this.inner.addAll(c);
        this.renew();
        return this;
    }

    @Override
    protected Supplier<Table> getElementSupplier() {
        return () -> new Table();
    }

    @Override
    public Table newElement() {
        return (Table)super.newElementInternal();
    }

    @Override
    protected boolean beforeRemove(Table arg) {
        super.beforeRemove(arg);
        arg.setPartitionParent(null);
        return true;
    }
}

