/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.util.StaxReader;
import java.util.function.Supplier;

class TableCollectionXmlReaderHandler
extends AbstractNamedObjectCollectionXmlReaderHandler<TableCollection> {
    public TableCollectionXmlReaderHandler() {
        super(() -> new TableCollection());
    }

    protected TableCollectionXmlReaderHandler(Supplier<TableCollection> supplier) {
        super(supplier);
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
        this.setChild(new Table().getDbObjectXmlReaderHandler());
    }

    @Override
    protected void finishDoHandle(StaxReader reader, Object parentObject, TableCollection tables) {
        this.setConstraints(tables);
    }

    private void setConstraints(TableCollection tables) {
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            this.setConstraints(tables, (Table)tables.get(i));
        }
    }

    private void setConstraints(TableCollection tables, Table table) {
        ConstraintCollection constraints = table.getConstraints();
        int size = constraints.size();
        for (int i = 0; i < size; ++i) {
            Constraint con = (Constraint)constraints.get(i);
            if (!(con instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint fk = (ForeignKeyConstraint)con;
            ReferenceColumnCollection cols = fk.getRelatedColumns();
            this.setColumns(tables, cols);
        }
    }

    private void setColumns(TableCollection tables, ReferenceColumnCollection columns) {
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            ReferenceColumn column = (ReferenceColumn)columns.get(i);
            Table table = (Table)tables.get(column.getTable().getName());
            if (table == null) continue;
            Column fkColumn = (Column)table.getColumns().get(column.getName());
            column.setColumn(fkColumn);
        }
    }
}

