/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class TableDropOrderComparator
implements Comparator<Table> {
    TableDropOrderComparator() {
    }

    @Override
    public int compare(Table table1, Table table2) {
        if (table1.getSchema() == null) {
            if (table2.getSchema() == null) {
                return this.compareName(table1, table2);
            }
            return 1;
        }
        if (table2.getSchema() == null) {
            return -1;
        }
        if (("flows".equals(table1.getName()) || "flows".equals(table2.getName())) && ("operations".equals(table1.getName()) || "operations".equals(table2.getName()))) {
            System.out.println("*");
        }
        return this.compareRelation(table1, table2);
    }

    protected int compareRelation(Table table1, Table table2) {
        int point2;
        int ret;
        Set<ForeignKeyConstraint> evaluated;
        List<ForeignKeyConstraint> fks1 = table1.getConstraints().getForeinKeyConstraints(fk -> !fk.getRelatedTable().equals(table1));
        List<ForeignKeyConstraint> fks2 = table2.getConstraints().getForeinKeyConstraints(fk -> !fk.getRelatedTable().equals(table2));
        List<ForeignKeyConstraint> cfks1 = table1.getChildRelations(fk -> !fk.getRelatedTable().equals(table1));
        List<ForeignKeyConstraint> cfks2 = table2.getChildRelations(fk -> !fk.getRelatedTable().equals(table2));
        if (CommonUtils.isEmpty(cfks1)) {
            if (CommonUtils.isEmpty(cfks2)) {
                return -Table.TableOrder.CREATE.getComparator().compare(table1, table2);
            }
            return cfks2.size() * this.noRelationMultiply();
        }
        if (CommonUtils.isEmpty(cfks2)) {
            return -cfks1.size() * this.noRelationMultiply();
        }
        int level = 5000000;
        for (ForeignKeyConstraint fk2 : fks1) {
            evaluated = CommonUtils.set();
            ret = this.isRelated(evaluated, fk2, table1, table2, level);
            if (ret == 0) continue;
            return -ret;
        }
        for (ForeignKeyConstraint fk2 : fks2) {
            evaluated = CommonUtils.set();
            ret = this.isRelated(evaluated, fk2, table2, table1, level);
            if (ret == 0) continue;
            return ret;
        }
        int point1 = this.countDependent(fks1);
        if (point1 != (point2 = this.countDependent(fks2))) {
            return -(point1 - point2) * this.relationMultiply();
        }
        if (fks1.size() != fks2.size()) {
            return -(fks1.size() - fks2.size()) * this.relationMultiply();
        }
        return this.compareName(table1, table2);
    }

    private int noRelationMultiply() {
        return 50000000;
    }

    private int schemaMultiply() {
        return 10;
    }

    private int relationMultiply() {
        return 5000;
    }

    private int compareName(Table table1, Table table2) {
        int count = this.compareName(table1.getSchemaName(), table2.getSchemaName());
        if (count != 0) {
            return -count * this.schemaMultiply();
        }
        count = this.compareName(table1.getName(), table2.getName());
        if (count != 0) {
            return -count;
        }
        return 0;
    }

    private int compareName(String name1, String name2) {
        if (name1 == null) {
            if (name2 == null) {
                return 0;
            }
            int count = CommonUtils.compare((Comparable)((Object)name2), (Object)name1);
            if (count > 0) {
                return -1;
            }
            if (count < 0) {
                return 1;
            }
        } else {
            int count = CommonUtils.compare((Comparable)((Object)name1), (Object)name2);
            if (count > 0) {
                return 1;
            }
            if (count < 0) {
                return -1;
            }
        }
        return 0;
    }

    protected int isRelated(Set<ForeignKeyConstraint> evaluated, ForeignKeyConstraint fk, Table table1, Table table2, int level) {
        if (evaluated.contains(fk)) {
            return level;
        }
        evaluated.add(fk);
        if (CommonUtils.eq(fk.getRelatedTable().getName(), table2.getName()) && (CommonUtils.eq(fk.getRelatedTable().getSchemaName(), table2.getSchemaName()) || fk.getRelatedTable().getSchemaName() == null)) {
            return level;
        }
        if (CommonUtils.eq(fk.getRelatedTable().getName(), table1.getName()) && (CommonUtils.eq(fk.getRelatedTable().getSchemaName(), table1.getSchemaName()) || fk.getRelatedTable().getSchemaName() == null)) {
            return 0;
        }
        List<ForeignKeyConstraint> fkParents = fk.getRelatedTable().getChildRelations();
        for (ForeignKeyConstraint fkParent : fkParents) {
            int ret = this.isDependent(fkParent) ? this.isRelated(evaluated, fkParent, table1, table2, level - this.relationMultiply()) : this.isRelated(evaluated, fkParent, table1, table2, level - this.relationMultiply() / 10);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private int countDependent(List<ForeignKeyConstraint> fks) {
        return (int)fks.stream().filter(fk -> this.isDependent((ForeignKeyConstraint)fk)).count();
    }

    private boolean isDependent(ForeignKeyConstraint fk) {
        for (Column column : fk.getColumns()) {
            if (column.isNotNull()) continue;
            return false;
        }
        return true;
    }
}

