/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.TableSpaceCollection;
import com.sqlapp.data.schemas.TableSpaceFileCollection;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.DefaultProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LocationProperty;
import com.sqlapp.data.schemas.properties.ReadonlyProperty;
import com.sqlapp.data.schemas.properties.complex.OwnerProperty;
import com.sqlapp.data.schemas.properties.object.TableSpaceFilesProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class TableSpace
extends AbstractNamedObject<TableSpace>
implements HasParent<TableSpaceCollection>,
ReadonlyProperty<TableSpace>,
OwnerProperty<TableSpace>,
DefaultProperty<TableSpace>,
LocationProperty<TableSpace>,
TableSpaceFilesProperty<TableSpace> {
    private static final long serialVersionUID = 3891888286502076232L;
    private String location = (String)SchemaProperties.LOCATION.getDefaultValue();
    private User owner = null;
    private TableSpaceFileCollection tableSpaceFiles = new TableSpaceFileCollection(this);
    private boolean _default = (Boolean)SchemaProperties.DEFAULT.getDefaultValue();
    private Boolean readonly = (Boolean)SchemaProperties.READONLY.getDefaultValue();

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public TableSpace setDefault(boolean _default) {
        this._default = _default;
        return this;
    }

    @Override
    public Boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public TableSpace setReadonly(Boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @Override
    protected TableSpace setParent(DbCommonObject<?> parent) {
        super.setParent(parent);
        return (TableSpace)this.instance();
    }

    public TableSpace() {
    }

    public TableSpace(String name) {
        super(name);
    }

    @Override
    protected Supplier<TableSpace> newInstance() {
        return () -> new TableSpace();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public TableSpace setLocation(String location) {
        this.location = location;
        return (TableSpace)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.LOCATION.getLabel(), this.getLocation());
        stax.writeAttribute(SchemaProperties.OWNER_NAME.getLabel(), this.getOwnerName());
        if (this.isDefault()) {
            stax.writeAttribute(SchemaProperties.DEFAULT.getLabel(), (Object)this.isDefault());
        }
        stax.writeAttribute(SchemaProperties.READONLY.getLabel(), (Object)this.getReadonly());
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.tableSpaceFiles)) {
            this.tableSpaceFiles.writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof TableSpace)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        TableSpace val = (TableSpace)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.OWNER_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOCATION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.READONLY, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.TABLE_SPACE_FILES, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.OWNER_NAME, this.getOwnerName());
        builder.add((ISchemaProperty)SchemaProperties.LOCATION, this.getLocation());
        builder.add((ISchemaProperty)SchemaProperties.DEFAULT, (Object)this.isDefault());
        builder.add((ISchemaProperty)SchemaProperties.READONLY, this.getOwnerName());
        builder.add((ISchemaProperty)SchemaObjectProperties.TABLE_SPACE_FILES, (Object)this.getTableSpaceFiles());
    }

    @Override
    public TableSpaceFileCollection getTableSpaceFiles() {
        return this.tableSpaceFiles;
    }

    protected TableSpace setTableSpaceFiles(TableSpaceFileCollection tableSpaceFiles) {
        this.tableSpaceFiles = tableSpaceFiles;
        if (this.tableSpaceFiles != null) {
            this.tableSpaceFiles.setParent(this);
        }
        return (TableSpace)this.instance();
    }

    @Override
    public TableSpaceCollection getParent() {
        return (TableSpaceCollection)super.getParent();
    }
}

