/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.DummyTableCollection;
import com.sqlapp.data.schemas.DummyTableCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.PrimaryKeyConstraintXmlReaderHandler;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.AbstractSetValue;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

class TableXmlReaderHandler
extends AbstractNamedObjectXmlReaderHandler<Table> {
    public TableXmlReaderHandler() {
        this(() -> new Table());
    }

    public TableXmlReaderHandler(Supplier<Table> supplier) {
        super(supplier);
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
        AbstractObjectXmlReaderHandler handler = new PrimaryKeyConstraintXmlReaderHandler();
        this.register(handler.getLocalName(), new AbstractSetValue<Table, UniqueConstraint>(){

            @Override
            public void setValue(Table target, String name, UniqueConstraint setValue) throws XMLStreamException {
                target.getConstraints().add(setValue);
            }
        });
        this.registerChild(handler);
        this.setAlias(handler.getLocalName(), SchemaProperties.PRIMARY_KEY.getLabel());
        handler = new RowCollectionXmlReaderHandler();
        this.register(handler.getLocalName(), new AbstractSetValue<Table, RowCollection>(){

            @Override
            public void setValue(Table target, String name, RowCollection setValue) throws XMLStreamException {
                target.getRows().addAll(setValue);
            }
        });
        this.registerChild(handler);
        handler = new DummyTableCollectionXmlReaderHandler(){

            @Override
            public String getLocalName() {
                return "inherits";
            }
        };
        this.register(handler.getLocalName(), new AbstractSetValue<Table, DummyTableCollection>(){

            @Override
            public void setValue(Table target, String name, DummyTableCollection setValue) throws XMLStreamException {
                target.getInherits().addAll(setValue.toTableCollection());
            }
        });
        this.registerChild(handler);
    }

    @Override
    protected void finishDoHandle(StaxReader reader, Object parentObject, Table table) {
        this.setConstraints(table);
    }

    private void setConstraints(Table table) {
        ConstraintCollection constraints = table.getConstraints();
        constraints.setParent(table);
    }

    protected TableCollection toParent(Object parentObject) {
        TableCollection parent = null;
        if (parentObject instanceof TableCollection) {
            parent = (TableCollection)parentObject;
        } else if (parentObject instanceof Schema) {
            Schema schema = (Schema)parentObject;
            parent = schema.getTables();
        }
        return parent;
    }
}

