/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TriggerCollection;
import com.sqlapp.data.schemas.properties.ActionConditionProperty;
import com.sqlapp.data.schemas.properties.ActionOrientationProperty;
import com.sqlapp.data.schemas.properties.ActionReferenceNewRowProperty;
import com.sqlapp.data.schemas.properties.ActionReferenceOldRowProperty;
import com.sqlapp.data.schemas.properties.ActionTimingProperty;
import com.sqlapp.data.schemas.properties.EnableProperty;
import com.sqlapp.data.schemas.properties.EventManipulationProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.WhenProperty;
import com.sqlapp.data.schemas.properties.complex.TableProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.xml.EmptyTextSkipHandler;
import com.sqlapp.util.xml.UpperSetHandler;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Trigger
extends Routine<Trigger>
implements HasParent<TriggerCollection>,
EnableProperty<Trigger>,
TableProperty<Trigger>,
EventManipulationProperty<Trigger>,
ActionReferenceOldRowProperty<Trigger>,
ActionReferenceNewRowProperty<Trigger>,
ActionConditionProperty<Trigger>,
ActionOrientationProperty<Trigger>,
ActionTimingProperty<Trigger>,
WhenProperty<Trigger> {
    private static final long serialVersionUID = -4906000020243009507L;
    private final Set<String> eventManipulation = CommonUtils.upperTreeSet();
    private String actionReferenceOldRow = null;
    private String actionReferenceNewRow = null;
    private boolean enable = (Boolean)SchemaProperties.ENABLE.getDefaultValue();
    private final Table table = null;
    private String actionCondition = null;
    private String actionOrientation = null;
    private String actionTiming = null;
    private String when = null;

    public Trigger() {
    }

    public Trigger(String name) {
        super(name);
    }

    @Override
    protected Supplier<Trigger> newInstance() {
        return () -> new Trigger();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.EVENT_MANIPULATION, this.getEventManipulation());
        builder.add((ISchemaProperty)SchemaProperties.ACTION_CONDITION, this.getActionCondition());
        builder.add((ISchemaProperty)SchemaProperties.ACTION_TIMING, this.getActionTiming());
        builder.add((ISchemaProperty)SchemaProperties.ACTION_ORIENTATION, this.getActionOrientation());
        builder.add((ISchemaProperty)SchemaProperties.ACTION_REFERENCE_OLD_ROW, this.getActionReferenceOldRow());
        builder.add((ISchemaProperty)SchemaProperties.ACTION_REFERENCE_NEW_ROW, this.getActionReferenceNewRow());
        builder.add((ISchemaProperty)SchemaProperties.ENABLE, (Object)this.isEnable());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_SCHEMA_NAME, this.getTableSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        builder.add((ISchemaProperty)SchemaProperties.WHEN, this.getWhen());
        super.toStringDetail(builder);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Trigger)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Trigger val = (Trigger)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.EVENT_MANIPULATION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACTION_CONDITION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACTION_ORIENTATION, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getActionOrientation(), val.getActionOrientation()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACTION_TIMING, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACTION_REFERENCE_OLD_ROW, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getActionReferenceOldRow(), val.getActionReferenceOldRow()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.ACTION_REFERENCE_NEW_ROW, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getActionReferenceNewRow(), val.getActionReferenceNewRow()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.ENABLE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.WHEN, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        if (this.getEventManipulation().size() != 0) {
            if (this.getEventManipulation().size() == 1) {
                stax.writeAttribute(SchemaProperties.EVENT_MANIPULATION.getLabel(), CommonUtils.first(this.getEventManipulation()));
            } else {
                SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
                builder.add(this.getEventManipulation());
                stax.writeAttribute(SchemaProperties.EVENT_MANIPULATION.getLabel(), builder.toString());
            }
        }
        stax.writeAttribute(SchemaProperties.ACTION_CONDITION.getLabel(), this.getActionCondition());
        stax.writeAttribute(SchemaProperties.ACTION_TIMING.getLabel(), this.getActionTiming());
        stax.writeAttribute(SchemaProperties.ACTION_ORIENTATION.getLabel(), this.getActionOrientation());
        stax.writeAttribute(SchemaProperties.ACTION_REFERENCE_OLD_ROW.getLabel(), this.getActionReferenceOldRow());
        stax.writeAttribute(SchemaProperties.ACTION_REFERENCE_NEW_ROW.getLabel(), this.getActionReferenceNewRow());
        if (!this.isEnable()) {
            stax.writeAttribute(SchemaProperties.ENABLE.getLabel(), (Object)this.isEnable());
        }
        stax.writeAttribute(SchemaProperties.TABLE_SCHEMA_NAME.getLabel(), this.getTableSchemaName());
        stax.writeAttribute(SchemaProperties.TABLE_NAME.getLabel(), this.getTableName());
        stax.writeAttribute(SchemaProperties.WHEN.getLabel(), this.getWhen());
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
    }

    @Override
    public Set<String> getEventManipulation() {
        return this.eventManipulation;
    }

    @Override
    public Trigger setEventManipulation(Set<String> eventManipulation) {
        this.eventManipulation.clear();
        if (eventManipulation != null) {
            this.eventManipulation.addAll(eventManipulation);
        }
        return this;
    }

    @Override
    public Trigger addEventManipulation(String ... args) {
        for (String arg : args) {
            String val = CommonUtils.trim(arg);
            if (CommonUtils.isEmpty(val)) continue;
            this.eventManipulation.add(val);
        }
        return this;
    }

    @Override
    public Trigger setEventManipulation(String arg) {
        if (arg == null || arg.length() == 0) {
            this.eventManipulation.clear();
            return this;
        }
        String[] vals = (arg = arg.toUpperCase()).split("\\s+OR\\s+");
        if (vals.length == 1) {
            vals = arg.split("[, |]");
        }
        return this.setEventManipulation(vals);
    }

    public Trigger setEventManipulation(String ... args) {
        this.eventManipulation.clear();
        return this.addEventManipulation(args);
    }

    @Override
    public String getActionTiming() {
        return this.actionTiming;
    }

    @Override
    public Trigger setActionTiming(String actionTiming) {
        this.actionTiming = actionTiming;
        return this;
    }

    @Override
    public Trigger addStatement(String ... lines) {
        for (String line : lines) {
            if (this.getStatement() == null) {
                this.setStatement(CommonUtils.list());
            }
            this.addStatement(line);
        }
        return this;
    }

    @Override
    public Trigger addStatement(Collection<String> lines) {
        for (String line : lines) {
            this.addStatement(line);
        }
        return this;
    }

    @Override
    public String getActionOrientation() {
        return this.actionOrientation;
    }

    @Override
    public Trigger setActionOrientation(String actionOrientation) {
        this.actionOrientation = actionOrientation;
        return (Trigger)this.instance();
    }

    @Override
    public String getActionReferenceOldRow() {
        return this.actionReferenceOldRow;
    }

    @Override
    public Trigger setActionReferenceOldRow(String actionReferenceOldRow) {
        this.actionReferenceOldRow = actionReferenceOldRow;
        return (Trigger)this.instance();
    }

    @Override
    public String getActionReferenceNewRow() {
        return this.actionReferenceNewRow;
    }

    @Override
    public Trigger setActionReferenceNewRow(String actionReferenceNewRow) {
        this.actionReferenceNewRow = actionReferenceNewRow;
        return (Trigger)this.instance();
    }

    @Override
    public String getWhen() {
        return this.when;
    }

    @Override
    public Trigger setWhen(String when) {
        this.when = when;
        return (Trigger)this.instance();
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public Trigger setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Override
    public String getActionCondition() {
        return this.actionCondition;
    }

    @Override
    public Trigger setActionCondition(String actionCondition) {
        this.actionCondition = actionCondition;
        return this;
    }

    @Override
    public TriggerCollection getParent() {
        return (TriggerCollection)super.getParent();
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<Trigger> getDbObjectXmlReaderHandler() {
        return new AbstractNamedObjectXmlReaderHandler<Trigger>(this.newInstance()){

            @Override
            protected void initializeSetValue() {
                super.initializeSetValue();
                this.registerTransparent(SchemaProperties.EVENT_MANIPULATION.getLabel(), new UpperSetHandler(), new EmptyTextSkipHandler());
            }
        };
    }

    @Override
    protected void validate() {
        super.validate();
        this.setTable(this.table);
    }
}

