/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.complex.DialectGetter;
import com.sqlapp.exceptions.FieldNotFoundException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface DataTypeNameProperty<T> {
    default public String getDataTypeName() {
        return (String)SimpleBeanUtils.getField(this, SchemaProperties.DATA_TYPE_NAME.getLabel());
    }

    default public T setDataTypeName(String dataTypeName) {
        if (dataTypeName != null) {
            String text = CommonUtils.trim(dataTypeName);
            String own = SchemaUtils.getDataTypeNameInternal(this);
            boolean bool = SchemaUtils.setDataTypeNameInternal(text, this);
            if (!bool) {
                throw new FieldNotFoundException(SchemaProperties.DATA_TYPE_NAME.getLabel(), this);
            }
            if (this instanceof DialectGetter) {
                DialectGetter dialectGetter = (DialectGetter)((Object)this);
                Dialect dialect = dialectGetter.getDialect();
                if (dialect != null && this instanceof DataTypeProperties) {
                    DataTypeProperties dataTypeProperties = (DataTypeProperties)this;
                    if (CommonUtils.eq(own, text) && dataTypeProperties.getDataType() != null) {
                        return (T)this;
                    }
                    if (this instanceof DataTypeLengthProperties) {
                        DataTypeLengthProperties obj = (DataTypeLengthProperties)this;
                        dialect.setDbType(text, obj.getLength(), obj.getScale(), obj);
                    } else if (this instanceof DataTypeProperties) {
                        DataTypeProperties obj = (DataTypeProperties)this;
                        dialect.setDbType(text, obj);
                    }
                    if (!(dataTypeProperties.getDataType() == null || dataTypeProperties.getDataType().isOther() || dataTypeProperties.getDataType().isDomain() || dataTypeProperties.getDataType().isType() || !dialect.matchDataTypeName(dataTypeProperties.getDataType(), dataTypeProperties.getDataTypeName()) || (bool = SchemaUtils.setDataTypeNameInternal(null, this)))) {
                        throw new FieldNotFoundException(SchemaProperties.DATA_TYPE_NAME.getLabel(), this);
                    }
                } else {
                    bool = SchemaUtils.setDataTypeNameInternal(CommonUtils.toUpperCase(text), this);
                    if (!bool) {
                        throw new FieldNotFoundException(SchemaProperties.DATA_TYPE_NAME.getLabel(), this);
                    }
                }
            }
        } else {
            boolean bool = SchemaUtils.setDataTypeNameInternal(null, this);
            if (!bool) {
                throw new FieldNotFoundException(SchemaProperties.DATA_TYPE_NAME.getLabel(), this);
            }
        }
        return (T)this;
    }
}

