/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.OwnerNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface OwnerProperty<T extends DbCommonObject<?>>
extends OwnerNameProperty<T> {
    default public User getOwner() {
        User obj = (User)SimpleBeanUtils.getField(this, SchemaProperties.OWNER_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setOwner(obj);
        }
        return obj;
    }

    default public T setOwner(User value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getUserFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.OWNER_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getOwnerName() {
        return this.getOwner() == null ? null : this.getOwner().getName();
    }

    @Override
    default public T setOwnerName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setOwner(null);
        } else if (this.getOwner() == null || !CommonUtils.eq(this.getOwnerName(), name)) {
            User obj = new User(name);
            this.setOwner(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

