/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface SchemaProperty<T extends DbCommonObject<?>>
extends SchemaNameProperty<T> {
    default public Schema getSchema() {
        Schema obj = (Schema)SimpleBeanUtils.getField(this, SchemaProperties.SCHEMA_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setSchema(obj);
        }
        return obj;
    }

    default public T setSchema(Schema value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getSchemaFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.SCHEMA_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getSchemaName() {
        return this.getSchema() == null ? null : this.getSchema().getName();
    }

    @Override
    default public T setSchemaName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setSchema(null);
        } else if (this.getSchema() == null || !CommonUtils.eq(this.getSchemaName(), name)) {
            Schema obj = new Schema(name);
            this.setSchema(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

