/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.util.CommonUtils;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class CombinedRowIteratorHandler
implements RowIteratorHandler {
    private List<RowIteratorHandler> rowIteratorHandlers = null;

    public CombinedRowIteratorHandler(List<RowIteratorHandler> rowIteratorHandlers) {
        this.rowIteratorHandlers = rowIteratorHandlers;
    }

    public CombinedRowIteratorHandler(RowIteratorHandler ... rowIteratorHandlers) {
        this.rowIteratorHandlers = CommonUtils.list(rowIteratorHandlers);
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        return new CombinedRowIterator(c, 0L, this.getAbstractRowListIterator(c));
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        return new CombinedRowIterator(c, index, this.getAbstractRowListIterator(c));
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return new CombinedRowIterator(c, 0L, this.getAbstractRowListIterator(c));
    }

    private List<ListIterator<Row>> getAbstractRowListIterator(RowCollection c) {
        return this.rowIteratorHandlers.stream().map(a -> a.listIterator(c)).collect(Collectors.toList());
    }

    public static class CombinedRowIterator
    implements ListIterator<Row>,
    AutoCloseable {
        private List<ListIterator<Row>> rowListIterators;
        long index;
        int handlerIndex = 0;

        protected CombinedRowIterator(RowCollection c, List<ListIterator<Row>> rowListIterators) {
            this.index = 0L;
            this.rowListIterators = rowListIterators;
        }

        protected CombinedRowIterator(RowCollection c, long index, List<ListIterator<Row>> rowListIterators) {
            this.index = index;
            this.rowListIterators = rowListIterators;
        }

        protected ListIterator<Row> getRowListIterator() {
            if (this.handlerIndex >= this.rowListIterators.size()) {
                return null;
            }
            ListIterator<Row> itr = this.rowListIterators.get(this.handlerIndex);
            try {
                if (!itr.hasNext()) {
                    this.closeSilent(itr);
                    ++this.handlerIndex;
                    return this.getRowListIterator();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return itr;
        }

        @Override
        public boolean hasNext() {
            ListIterator<Row> itr = this.getRowListIterator();
            return itr != null && itr.hasNext();
        }

        @Override
        public Row next() {
            Row row = this.nextInternal();
            return row;
        }

        protected Row nextInternal() {
            ListIterator<Row> itr = this.getRowListIterator();
            if (itr != null && itr.hasNext()) {
                return itr.next();
            }
            return null;
        }

        @Override
        public void close() throws Exception {
            for (ListIterator<Row> itr : this.rowListIterators) {
                if (!(itr instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)itr)).close();
            }
        }

        private void closeSilent(Object obj) {
            if (obj instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)obj).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support hasPrevious.");
        }

        @Override
        public Row previous() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support previous.");
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support nextIndex.");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support previousIndex.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support remove.");
        }

        @Override
        public void set(Row e) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support set.");
        }

        @Override
        public void add(Row e) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support add.");
        }
    }
}

