/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelUtils {
    public static int getCellWidthByType(Column column) {
        if (column.getDataType().isNumeric()) {
            if (column.getDataType().isFixedSize()) {
                if (column.getLength() != null) {
                    return column.getLength().intValue();
                }
                return 10;
            }
            switch (column.getDataType()) {
                case BIT: {
                    return 1;
                }
                case TINYINT: 
                case UTINYINT: {
                    return 3;
                }
                case SMALLINT: 
                case USMALLINT: {
                    return 5;
                }
                case MEDIUMINT: 
                case UMEDIUMINT: {
                    return 8;
                }
                case INT: 
                case UINT: {
                    return 10;
                }
                case BIGINT: 
                case UBIGINT: {
                    return 19;
                }
            }
            return 10;
        }
        if (column.getDataType().isBoolean()) {
            return 5;
        }
        if (column.getDataType().isDateTime()) {
            return 10;
        }
        return 10;
    }

    public static int getCellWidth(Column column) {
        int width = ExcelUtils.getCellWidthByType(column);
        int width2 = ExcelUtils.getCellWidth(column.getName());
        return Math.max(width, width2);
    }

    public static int getCellWidth(String value) {
        return StringUtils.getDisplayWidth(value);
    }

    public static String getStringCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        return cell.getStringCellValue();
    }

    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case BLANK: {
                return null;
            }
            case _NONE: {
                return null;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case FORMULA: {
                return ExcelUtils.getFormulaCellValue(cell);
            }
        }
        return null;
    }

    private static Object getFormulaCellValue(Cell cell) {
        CellValue value = ExcelUtils.getEvaluatedCellValue(cell);
        switch (value.getCellType()) {
            case BLANK: {
                return null;
            }
            case _NONE: {
                return null;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateUtil.getJavaDate((double)value.getNumberValue());
                }
                return value.getNumberValue();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    private static CellValue getEvaluatedCellValue(Cell cell) {
        Workbook book = cell.getSheet().getWorkbook();
        CreationHelper helper = book.getCreationHelper();
        FormulaEvaluator evaluator = helper.createFormulaEvaluator();
        CellValue value = evaluator.evaluate(cell);
        return value;
    }

    public static void setColumnType(Cell cell, Column column) {
        switch (cell.getCellType()) {
            case BLANK: {
                if (column.getDataType() != null && column.getDataType() != DataType.NVARCHAR) {
                    return;
                }
                column.setDataType(DataType.NVARCHAR);
                column.setLength(DialectUtils.getDefaultTypeLength(null));
                break;
            }
            case BOOLEAN: {
                if (column.getDataType() != null && column.getDataType() != DataType.BOOLEAN) {
                    return;
                }
                column.setDataType(DataType.BOOLEAN);
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    if (column.getDataType() != null && column.getDataType() != DataType.DATETIME) {
                        return;
                    }
                    column.setDataType(DataType.DATETIME);
                    break;
                }
                if (ExcelUtils.hasDecimalPoint(cell)) {
                    column.setDataType(DataType.DOUBLE);
                    break;
                }
                if (column.getDataType() == DataType.DOUBLE) break;
                column.setDataType(DataType.BIGINT);
                break;
            }
            case STRING: {
                column.setDataType(DataType.NVARCHAR);
                column.setLength(DialectUtils.getDefaultTypeLength(null));
            }
        }
    }

    private static boolean hasDecimalPoint(Cell cell) {
        double dbValue2;
        double dbValue = cell.getNumericCellValue();
        return dbValue != (dbValue2 = (double)Math.round(dbValue));
    }

    public static Sheet getFirstOrCreateSeet(Workbook workbook, String sheetName) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            if (workbook.getNumberOfSheets() > 0) {
                sheet = workbook.getSheetAt(0);
            }
            if (sheet == null) {
                return workbook.createSheet(sheetName);
            }
        }
        return sheet;
    }

    public static Sheet getOrCreateSeet(Workbook workbook, String sheetName) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            return workbook.createSheet(sheetName);
        }
        return sheet;
    }

    public static Row getOrCreateRow(Sheet sheet, int rownum) {
        Row row = sheet.getRow(rownum);
        if (row == null) {
            row = sheet.createRow(rownum);
        }
        return row;
    }

    public static Cell getOrCreateCell(Row row, int cellnum) {
        Cell cell = row.getCell(cellnum);
        if (cell == null) {
            cell = row.createCell(cellnum);
        }
        return cell;
    }

    public static void readWorkbook(File file, WorkbookHandler workbookHandler) throws FileNotFoundException {
        FileInputStream in = null;
        Workbook workbook = null;
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            in = new FileInputStream(file);
            workbook = WorkbookFactory.create((InputStream)in);
            workbookHandler.handle(workbook);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                throw throwable;
            }
        }
        FileUtils.close(in);
    }

    public static void writeWorkbook(Workbook workbook, File file) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedOutputStream bs = new BufferedOutputStream(os);){
            workbook.write((OutputStream)bs);
        }
    }

    public static void setCell(Converters converters, Workbook workbook, Cell cell, Object obj) {
        if (obj instanceof Boolean) {
            cell.setCellValue(((Boolean)obj).booleanValue());
        } else if (obj instanceof Double) {
            cell.setCellValue(((Double)obj).doubleValue());
        } else if (obj instanceof Number) {
            cell.setCellValue(converters.convertObject(obj, Double.class).doubleValue());
        } else if (obj == null) {
            cell.setCellValue((String)null);
        } else if (converters.isConvertable(obj.getClass())) {
            cell.setCellValue(converters.convertString(obj));
        } else {
            cell.setCellValue(obj.toString());
        }
    }

    public static void setComment(CreationHelper helper, Cell cell, String text) {
        int dx1 = 200;
        int dy1 = 100;
        int dx2 = 200;
        int dy2 = 100;
        int col1 = cell.getColumnIndex() + 1;
        int row1 = cell.getRowIndex();
        int col2 = col1 + 3;
        String[] args = text.split("\n");
        int row2 = row1 + args.length + 1;
        Drawing drawing = cell.getSheet().createDrawingPatriarch();
        ClientAnchor anchor = drawing.createAnchor(200, 100, 200, 100, col1, row1, col2, row2);
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(helper.createRichTextString(text));
        cell.setCellComment(comment);
    }

    public static void setCell(Workbook workbook, Cell cell, Object obj) {
        ExcelUtils.setCell(Converters.getDefault(), workbook, cell, obj);
    }

    public static void clearCellValues(Sheet sheet) {
        Iterator itr = sheet.rowIterator();
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            if (row.getRowNum() == 0) continue;
            Iterator citr = row.cellIterator();
            while (citr.hasNext()) {
                Cell cell = (Cell)citr.next();
                if (cell == null || CellType.FORMULA == cell.getCellType()) continue;
                cell.setCellValue((String)null);
            }
        }
    }

    @FunctionalInterface
    public static interface WorkbookHandler {
        public void handle(Workbook var1);
    }
}

