/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.util.eval.EvalExecutor;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import com.sqlapp.util.eval.mvel.MvelUtils;
import java.io.File;
import java.io.IOException;

public class ExpressionConverter {
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders;
    private File fileDirectory = null;
    private CachedMvelEvaluator cachedMvelEvaluator = new CachedMvelEvaluator();

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public boolean isPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    public File getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
        if (fileDirectory != null) {
            MvelUtils.setBasePath(fileDirectory.getAbsolutePath());
        }
    }

    public Object convert(Object value, Object context) throws IOException {
        if (value == null) {
            return value;
        }
        if (this.isPlaceholders()) {
            return this.convertInternal(value, context);
        }
        return value;
    }

    private Object convertInternal(Object value, Object context) throws IOException {
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String text = (String)String.class.cast(value);
        if (text.startsWith(this.getPlaceholderPrefix()) && text.endsWith(this.getPlaceholderSuffix())) {
            String expression = text.substring(this.getPlaceholderPrefix().length(), text.length() - this.getPlaceholderSuffix().length());
            MvelUtils.setBasePath(this.fileDirectory.getAbsolutePath());
            EvalExecutor evalExecutor = this.cachedMvelEvaluator.getEvalExecutor(expression);
            Object obj = evalExecutor.eval(context);
            return obj;
        }
        return value;
    }
}

