/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractTextRowListIterator;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.file.AbstractFileParser;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Format;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;

public class FileTypeRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final File file;
    private final Path path;
    private final WorkbookFileType workbookFileType;
    private final String charset;
    private final Reader reader;
    private final int skipHeaderRowsSize;

    public FileTypeRowIteratorHandler(File file, String charset) {
        this(file, charset, 1);
    }

    public FileTypeRowIteratorHandler(File file, String charset, int skipHeaderRowsSize) {
        super((r, c, v) -> v);
        this.workbookFileType = WorkbookFileType.parse(file);
        this.file = file;
        this.path = null;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public FileTypeRowIteratorHandler(Path path, String charset) {
        this(path, charset, 1);
    }

    public FileTypeRowIteratorHandler(Path path, String charset, int skipHeaderRowsSize) {
        super((r, c, v) -> v);
        this.workbookFileType = WorkbookFileType.parse(path);
        this.file = null;
        this.path = path;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public FileTypeRowIteratorHandler(File file, String charset, RowValueConverter valueConverter) {
        this(file, charset, 1, valueConverter);
    }

    public FileTypeRowIteratorHandler(File file, String charset, int skipHeaderRowsSize, RowValueConverter valueConverter) {
        super(valueConverter);
        this.workbookFileType = WorkbookFileType.parse(file);
        this.file = file;
        this.path = null;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public FileTypeRowIteratorHandler(Reader reader, WorkbookFileType workbookFileType) {
        this(reader, 1, workbookFileType);
    }

    public FileTypeRowIteratorHandler(Reader reader, int skipHeaderRowsSize, WorkbookFileType workbookFileType) {
        super((r, c, v) -> v);
        this.workbookFileType = workbookFileType;
        this.file = null;
        this.path = null;
        this.charset = null;
        this.reader = reader;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        if (this.file != null) {
            return new FileTypeRowIterator(c, this.file, this.skipHeaderRowsSize, this.workbookFileType, this.charset, 0L, this.getRowValueConverter());
        }
        if (this.path != null) {
            return new FileTypeRowIterator(c, this.path, this.skipHeaderRowsSize, this.workbookFileType, this.charset, 0L, this.getRowValueConverter());
        }
        return new FileTypeRowIterator(c, this.reader, this.skipHeaderRowsSize, this.workbookFileType, 0L, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        if (this.file != null) {
            return new FileTypeRowIterator(c, this.file, this.skipHeaderRowsSize, this.workbookFileType, this.charset, (long)index, this.getRowValueConverter());
        }
        if (this.path != null) {
            return new FileTypeRowIterator(c, this.path, this.skipHeaderRowsSize, this.workbookFileType, this.charset, (long)index, this.getRowValueConverter());
        }
        return new FileTypeRowIterator(c, this.reader, this.skipHeaderRowsSize, this.workbookFileType, index, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return (ListIterator)this.iterator(c);
    }

    static class ColumnPosition {
        public final int index;
        public final Column column;

        ColumnPosition(int index, Column column) {
            this.index = index;
            this.column = column;
        }
    }

    public static class FileTypeRowIterator
    extends AbstractTextRowListIterator<String[]> {
        private final File file;
        private final Path path;
        private final WorkbookFileType workbookFileType;
        private final String charset;
        private Reader reader;
        private AbstractFileParser<?, ?> fileReader;
        private String filename;
        private List<ColumnPosition> columns;
        private String[] current = null;
        private final int skipHeaderRowsSize;
        private final Consumer<CommonParserSettings<? extends Format>> settingConsumer;
        private boolean readed;

        FileTypeRowIterator(RowCollection c, Path path, int skipHeaderRowsSize, WorkbookFileType workbookFileType, String charset, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.settingConsumer = s -> {};
            this.readed = false;
            this.workbookFileType = workbookFileType;
            this.file = null;
            this.path = path;
            this.charset = charset;
            this.filename = path.toFile().getName();
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        FileTypeRowIterator(RowCollection c, File file, int skipHeaderRowsSize, WorkbookFileType workbookFileType, String charset, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.settingConsumer = s -> {};
            this.readed = false;
            this.workbookFileType = workbookFileType;
            this.file = file;
            this.path = null;
            this.charset = charset;
            this.filename = file.getAbsolutePath();
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        FileTypeRowIterator(RowCollection c, Reader reader, int skipHeaderRowsSize, WorkbookFileType workbookFileType, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.settingConsumer = s -> {};
            this.readed = false;
            this.workbookFileType = workbookFileType;
            this.file = null;
            this.path = null;
            this.reader = reader;
            this.charset = null;
            this.filename = null;
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        @Override
        protected void preInitialize() throws Exception {
            if (this.file != null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset));
                this.fileReader = this.workbookFileType.getFileType().createParser(this.file, this.charset, this.settingConsumer);
                this.filename = this.file.getAbsolutePath();
            } else if (this.path != null) {
                this.reader = Files.newBufferedReader(this.path, Charset.forName(this.charset));
                this.fileReader = this.workbookFileType.getFileType().createParser(this.reader, this.settingConsumer);
                this.filename = this.path.toFile().getAbsolutePath();
            } else {
                this.fileReader = this.workbookFileType.getFileType().createParser(this.reader, this.settingConsumer);
                this.filename = null;
            }
            this.fileReader.beginParsing();
        }

        @Override
        protected void initializeColumn() throws Exception {
            block9: {
                int i;
                block7: {
                    String[] list;
                    block8: {
                        if (this.skipHeaderRowsSize != 1) break block7;
                        this.columns = CommonUtils.list();
                        list = this.fileReader.parseNext();
                        if (!CommonUtils.isEmpty(this.table.getColumns())) break block8;
                        int i2 = 0;
                        for (String columnName : list) {
                            Column column = new Column(columnName);
                            this.columns.add(new ColumnPosition(i2, column));
                            this.table.getColumns().add(column);
                            ++i2;
                        }
                        break block9;
                    }
                    int i3 = 0;
                    for (String columnName : list) {
                        Column column = this.searchColumn(this.table, columnName);
                        if (column != null) {
                            this.columns.add(new ColumnPosition(i3, column));
                        } else {
                            this.columns.add(new ColumnPosition(i3, null));
                        }
                        ++i3;
                    }
                    if (!this.columns.isEmpty()) break block9;
                    i3 = 0;
                    for (Column column : this.table.getColumns()) {
                        this.columns.add(new ColumnPosition(i3, column));
                        ++i3;
                    }
                    break block9;
                }
                for (i = 0; i < this.skipHeaderRowsSize; ++i) {
                    String[] list = this.fileReader.parseNext();
                    if (list != null) continue;
                    return;
                }
                this.columns = CommonUtils.list();
                i = 0;
                for (Column column : this.table.getColumns()) {
                    this.columns.add(new ColumnPosition(i, column));
                    ++i;
                }
            }
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            this.readInternal();
            return this.current != null;
        }

        protected String[] readInternal() throws Exception {
            if (this.readed) {
                return this.current;
            }
            this.current = this.fileReader.parseNext();
            this.readed = true;
            return this.current;
        }

        @Override
        protected String[] read() throws Exception {
            this.current = this.readInternal();
            this.readed = false;
            return this.current;
        }

        @Override
        protected void set(String[] val, Row row) throws Exception {
            row.setDataSourceInfo(this.filename);
            row.setDataSourceRowNumber(this.fileReader.getLineNumber());
            int i = 0;
            if (val == null) {
                return;
            }
            for (String text : val) {
                if (i >= this.columns.size()) continue;
                ColumnPosition columnPosition = this.columns.get(i++);
                Column column = columnPosition.column;
                if (column == null) continue;
                DataType type = this.getDataType(text);
                if (type != null) {
                    if (column.getDataType() == null) {
                        column.setDataType(type);
                    } else if (!column.getDataType().isCharacter() && !type.isBoolean() && column.getDataType() != DataType.DOUBLE) {
                        column.setDataType(type);
                    }
                }
                long len = this.getTypeLength(text);
                if (column.getLength() != null) {
                    column.setLength(Math.max(len, column.getLength()));
                } else {
                    column.setLength(len);
                }
                this.put(row, column, text);
            }
        }

        @Override
        protected void doClose() {
            FileUtils.close(this.reader);
            this.fileReader.close();
            this.reader = null;
        }
    }
}

