/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.rowiterator.AbstractRowListIterator;
import com.sqlapp.jdbc.ConnectionHandler;
import com.sqlapp.jdbc.DataSourceConnectionHandler;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.DefaultPredicate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import javax.sql.DataSource;

public class JdbcDynamicRowIteratorHandler
implements RowIteratorHandler {
    private DataSource dataSource = null;
    private Predicate<RowCollection> filter = new DefaultPredicate<RowCollection>();
    private Options option = null;

    @Override
    public Iterator<Row> iterator(RowCollection rows) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, 0);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.iterator();
    }

    protected ConnectionHandler getConnectionHandler() {
        return new DataSourceConnectionHandler(this.getDataSource());
    }

    protected ResultSetIterator getResultSetIterator(RowCollection rows, int index) {
        ResultSetIterator iterator = new ResultSetIterator(rows, this.getConnectionHandler(), index, this.getOptions());
        return iterator;
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection rows, int index) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, index);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.listIterator();
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection rows) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, 0);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.listIterator();
    }

    public Predicate<RowCollection> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<RowCollection> filter) {
        this.filter = filter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Options getOptions() {
        return this.option;
    }

    public void setOptions(Options option) {
        this.option = option;
    }

    static class ColumnPosition {
        public final int index;
        public final Column column;
        public final JdbcTypeHandler jdbcTypeHandler;

        ColumnPosition(int index, Column column, JdbcTypeHandler jdbcTypeHandler) {
            this.index = index;
            this.column = column;
            this.jdbcTypeHandler = jdbcTypeHandler;
        }
    }

    public static class ResultSetIterator
    extends AbstractRowListIterator<ResultSet> {
        private final List<ColumnPosition> columnList = CommonUtils.list();
        private Connection connection;
        private PreparedStatement statement;
        private ResultSet resultSet;
        private Dialect dialect;
        private final Options options;
        private final ConnectionHandler connectionHandler;

        public ResultSetIterator(RowCollection rows, ConnectionHandler connectionHandler, int index, Options options) {
            super(rows, index, (r, c, v) -> v);
            this.connectionHandler = connectionHandler;
            this.options = options;
        }

        @Override
        protected void preInitialize() throws Exception {
            this.connection = this.connectionHandler.getConnection();
            this.statement = this.createStatement();
            this.resultSet = this.createResultSet();
        }

        @Override
        protected void initializeColumn() throws Exception {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String label = resultSetMetaData.getColumnLabel(i);
                String name = resultSetMetaData.getColumnName(i);
                Column column = this.searchColumn(this.table, label);
                if (column == null) {
                    column = this.searchColumn(this.table, name);
                }
                if (column == null) continue;
                DbDataType<?> type = this.dialect.getDbDataType(column);
                if (type == null) {
                    throw new NullPointerException("type is null. column=" + column);
                }
                ColumnPosition columnPosition = new ColumnPosition(i, column, type.getJdbcTypeHandler());
                this.columnList.add(columnPosition);
            }
        }

        @Override
        protected ResultSet read() throws Exception {
            return this.resultSet;
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            return this.resultSet.next();
        }

        protected PreparedStatement createStatement() throws SQLException {
            return this.connection.prepareStatement(this.createSql(this.table));
        }

        protected ResultSet createResultSet() throws SQLException {
            ResultSet resultSet = this.statement.executeQuery();
            resultSet.setFetchSize(1000);
            return resultSet;
        }

        protected String createSql(Table table) throws SQLException {
            this.dialect = DialectResolver.getInstance().getDialect(this.connection);
            Object sqlFactory = this.dialect.createSqlFactoryRegistry().getSqlFactory(table, SqlType.SELECT_ALL);
            Options options = this.options != null ? this.options.clone() : sqlFactory.getOptions().clone();
            options.setDecorateSchemaName(true);
            sqlFactory.setOptions(options);
            List<SqlOperation> operationTexts = sqlFactory.createSql((Table)table);
            SqlOperation operationText = CommonUtils.first(operationTexts);
            return operationText.getSqlText();
        }

        @Override
        protected void doClose() {
            DbUtils.close(this.resultSet);
            DbUtils.close(this.statement);
            try {
                this.connectionHandler.releaseConnection(this.connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultSet = null;
            this.statement = null;
            this.connection = null;
        }

        @Override
        protected void set(ResultSet val, Row row) throws Exception {
            int size = this.columnList.size();
            for (int i = 0; i < size; ++i) {
                ColumnPosition columnPosition = this.columnList.get(i);
                Column column = columnPosition.column;
                Object obj = columnPosition.jdbcTypeHandler.getObject(this.resultSet, columnPosition.index);
                row.put(column.getOrdinal(), obj);
            }
        }
    }
}

